/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

public final class ClassUtil {
    private static final Object[][] _codes = new Object[][]{{Byte.TYPE, "byte", "B"}, {Character.TYPE, "char", "C"}, {Double.TYPE, "double", "D"}, {Float.TYPE, "float", "F"}, {Integer.TYPE, "int", "I"}, {Long.TYPE, "long", "J"}, {Short.TYPE, "short", "S"}, {Boolean.TYPE, "boolean", "Z"}, {Void.TYPE, "void", "V"}};

    private ClassUtil() {
    }

    public static Class toClass(String str, ClassLoader loader) {
        return ClassUtil.toClass(str, false, loader);
    }

    public static Class toClass(String str, boolean resolve, ClassLoader loader) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        int dims = 0;
        while (str.endsWith("[]")) {
            ++dims;
            str = str.substring(0, str.length() - 2);
        }
        boolean primitive = false;
        if (str.indexOf(46) == -1) {
            for (int i = 0; !primitive && i < _codes.length; ++i) {
                if (!_codes[i][1].equals(str)) continue;
                if (dims == 0) {
                    return (Class)_codes[i][0];
                }
                str = (String)_codes[i][2];
                primitive = true;
            }
        }
        if (dims > 0) {
            StringBuilder buf = new StringBuilder(str.length() + dims + 2);
            for (int i = 0; i < dims; ++i) {
                buf.append('[');
            }
            if (!primitive) {
                buf.append('L');
            }
            buf.append(str);
            if (!primitive) {
                buf.append(';');
            }
            str = buf.toString();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return Class.forName(str, resolve, loader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String getClassName(Class cls) {
        if (cls == null) {
            return null;
        }
        return ClassUtil.getClassName(cls.getName());
    }

    public static String getClassName(String fullName) {
        int lastDot;
        String simpleName;
        if (fullName == null) {
            return null;
        }
        if (fullName.isEmpty()) {
            return fullName;
        }
        int dims = ClassUtil.getArrayDimensions(fullName);
        if (dims > 0) {
            if (fullName.length() == dims + 1) {
                String classCode = fullName.substring(dims);
                for (int i = 0; i < _codes.length; ++i) {
                    if (!_codes[i][2].equals(classCode)) continue;
                    fullName = (String)_codes[i][1];
                    break;
                }
            } else {
                fullName = fullName.charAt(fullName.length() - 1) == ';' ? fullName.substring(dims + 1, fullName.length() - 1) : fullName.substring(dims + 1);
            }
        }
        String string = simpleName = (lastDot = fullName.lastIndexOf(46)) > -1 ? fullName.substring(lastDot + 1) : fullName;
        if (dims > 0) {
            StringBuilder sb = new StringBuilder(simpleName.length() + dims * 2);
            sb.append(simpleName);
            for (int i = 0; i < dims; ++i) {
                sb.append("[]");
            }
            simpleName = sb.toString();
        }
        return simpleName;
    }

    private static int getArrayDimensions(String fullClassName) {
        int dims = 0;
        while (fullClassName.charAt(dims) == '[') {
            ++dims;
        }
        return dims;
    }

    public static String getPackageName(Class cls) {
        return cls == null ? null : ClassUtil.getPackageName(cls.getName());
    }

    public static String getPackageName(String fullName) {
        int lastDot;
        if (fullName == null) {
            return null;
        }
        if (fullName.isEmpty()) {
            return fullName;
        }
        int dims = ClassUtil.getArrayDimensions(fullName);
        if (dims > 0) {
            if (fullName.length() == dims + 1) {
                return "";
            }
            fullName = fullName.substring(dims + 1);
        }
        return (lastDot = fullName.lastIndexOf(46)) > -1 ? fullName.substring(0, lastDot) : "";
    }
}

