/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.election;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.concurrent.BlockUtils;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.base.LeaderExecutionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LeaderService.class);
    private final String jobName;
    private final ServerService serverService;
    private final JobNodeStorage jobNodeStorage;

    public LeaderService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    public void electLeader() {
        log.debug("Elect a new leader now.");
        this.jobNodeStorage.executeInLeader("leader/election/latch", new LeaderElectionExecutionCallback());
        log.debug("Leader election completed.");
    }

    public boolean isLeaderUntilBlock() {
        while (!this.hasLeader() && this.serverService.hasAvailableServers()) {
            log.info("Leader is electing, waiting for {} ms", (Object)100);
            BlockUtils.waitingShortTime();
            if (JobRegistry.getInstance().isShutdown(this.jobName) || !this.serverService.isAvailableServer(JobRegistry.getInstance().getJobInstance(this.jobName).getServerIp())) continue;
            this.electLeader();
        }
        return this.isLeader();
    }

    public boolean isLeader() {
        return !JobRegistry.getInstance().isShutdown(this.jobName) && JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId().equals(this.jobNodeStorage.getJobNodeData("leader/election/instance"));
    }

    public boolean hasLeader() {
        return this.jobNodeStorage.isJobNodeExisted("leader/election/instance");
    }

    public void removeLeader() {
        this.jobNodeStorage.removeJobNodeIfExisted("leader/election/instance");
    }

    class LeaderElectionExecutionCallback
    implements LeaderExecutionCallback {
        public void execute() {
            if (!LeaderService.this.hasLeader()) {
                LeaderService.this.jobNodeStorage.fillEphemeralJobNode("leader/election/instance", JobRegistry.getInstance().getJobInstance(LeaderService.this.jobName).getJobInstanceId());
            }
        }

        @Generated
        public LeaderElectionExecutionCallback() {
        }
    }
}

