/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.trigger;

import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;

public final class TriggerNode {
    public static final String ROOT = "trigger";
    private static final String TRIGGER = "trigger/%s";
    private final String jobName;
    private final JobNodePath jobNodePath;

    public TriggerNode(String jobName) {
        this.jobName = jobName;
        this.jobNodePath = new JobNodePath(jobName);
    }

    public boolean isLocalTriggerPath(String path) {
        JobInstance jobInstance = JobRegistry.getInstance().getJobInstance(this.jobName);
        return null != jobInstance && path.equals(this.jobNodePath.getFullPath(String.format(TRIGGER, jobInstance.getJobInstanceId())));
    }

    public String getLocalTriggerPath() {
        return this.getTriggerPath(JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId());
    }

    public String getTriggerPath(String instanceId) {
        return String.format(TRIGGER, instanceId);
    }

    public String getTriggerRoot() {
        return ROOT;
    }
}

