/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.latest;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@MeterFunction(functionName="latest")
public abstract class LatestFunction
extends Meter
implements AcceptableValue<Long>,
LongValueHolder {
    protected static final String VALUE = "value";
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @ElasticSearch.EnableDocValues
    @Column(name="value", dataType=Column.ValueDataType.COMMON_VALUE)
    @BanyanDB.MeasureField
    private long value;

    @Override
    public void accept(MeterEntity entity, Long value) {
        this.decorate(entity);
        this.entityId = entity.id();
        this.serviceId = entity.serviceId();
        this.value = value;
    }

    @Override
    public final boolean combine(Metrics metrics) {
        LatestFunction latestFunction = (LatestFunction)metrics;
        this.value = latestFunction.value;
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        LatestFunction metrics = (LatestFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        metrics.setAttr0(this.getAttr0());
        metrics.setAttr1(this.getAttr1());
        metrics.setAttr2(this.getAttr2());
        metrics.setAttr3(this.getAttr3());
        metrics.setAttr4(this.getAttr4());
        metrics.setAttr5(this.getAttr5());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        LatestFunction metrics = (LatestFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        metrics.setAttr0(this.getAttr0());
        metrics.setAttr1(this.getAttr1());
        metrics.setAttr2(this.getAttr2());
        metrics.setAttr3(this.getAttr3());
        metrics.setAttr4(this.getAttr4());
        metrics.setAttr5(this.getAttr5());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.value = remoteData.getDataLongs(0);
        this.setTimeBucket(remoteData.getDataLongs(1));
        this.entityId = remoteData.getDataStrings(0);
        this.serviceId = remoteData.getDataStrings(1);
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(2))) {
            this.setAttr0(remoteData.getDataStrings(2));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(3))) {
            this.setAttr1(remoteData.getDataStrings(3));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(4))) {
            this.setAttr2(remoteData.getDataStrings(4));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(5))) {
            this.setAttr3(remoteData.getDataStrings(5));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(6))) {
            this.setAttr4(remoteData.getDataStrings(6));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(7))) {
            this.setAttr5(remoteData.getDataStrings(7));
        }
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.value);
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataStrings(this.serviceId);
        remoteBuilder.addDataStrings(this.getAttr0() == null ? "" : this.getAttr0());
        remoteBuilder.addDataStrings(this.getAttr1() == null ? "" : this.getAttr1());
        remoteBuilder.addDataStrings(this.getAttr2() == null ? "" : this.getAttr2());
        remoteBuilder.addDataStrings(this.getAttr3() == null ? "" : this.getAttr3());
        remoteBuilder.addDataStrings(this.getAttr4() == null ? "" : this.getAttr4());
        remoteBuilder.addDataStrings(this.getAttr5() == null ? "" : this.getAttr5());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public Class<? extends LatestStorageBuilder> builder() {
        return LatestStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatestFunction)) {
            return false;
        }
        LatestFunction function = (LatestFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "LatestFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }

    public static class LatestStorageBuilder
    implements StorageBuilder<LatestFunction> {
        @Override
        public LatestFunction storage2Entity(Convert2Entity converter) {
            LatestFunction metrics = new LatestFunction(){

                @Override
                public AcceptableValue<Long> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setValue(((Number)converter.get(LatestFunction.VALUE)).longValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            metrics.setAttr0((String)converter.get("attr0"));
            metrics.setAttr1((String)converter.get("attr1"));
            metrics.setAttr2((String)converter.get("attr2"));
            metrics.setAttr3((String)converter.get("attr3"));
            metrics.setAttr4((String)converter.get("attr4"));
            metrics.setAttr5((String)converter.get("attr5"));
            return metrics;
        }

        @Override
        public void entity2Storage(LatestFunction storageData, Convert2Storage converter) {
            converter.accept(LatestFunction.VALUE, storageData.getValue());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
            converter.accept("attr0", storageData.getAttr0());
            converter.accept("attr1", storageData.getAttr1());
            converter.accept("attr2", storageData.getAttr2());
            converter.accept("attr3", storageData.getAttr3());
            converter.accept("attr4", storageData.getAttr4());
            converter.accept("attr5", storageData.getAttr5());
        }
    }
}

