/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import org.apache.skywalking.oap.server.core.analysis.manual.log.LogRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.exporter.LogExportService;
import org.apache.skywalking.oap.server.core.exporter.TraceExportService;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class ExportRecordWorker
extends AbstractWorker<Record> {
    private TraceExportService traceExportService;
    private LogExportService logExportService;

    public ExportRecordWorker(ModuleDefineHolder moduleDefineHolder) {
        super(moduleDefineHolder);
    }

    @Override
    public void in(Record record) {
        if (record instanceof SegmentRecord) {
            if (this.traceExportService != null || this.getModuleDefineHolder().has("exporter")) {
                if (this.traceExportService == null) {
                    this.traceExportService = (TraceExportService)this.getModuleDefineHolder().find("exporter").provider().getService(TraceExportService.class);
                }
                if (this.traceExportService.isEnabled()) {
                    this.traceExportService.export((SegmentRecord)record);
                }
            }
        } else if (record instanceof LogRecord && (this.logExportService != null || this.getModuleDefineHolder().has("exporter"))) {
            if (this.logExportService == null) {
                this.logExportService = (LogExportService)this.getModuleDefineHolder().find("exporter").provider().getService(LogExportService.class);
            }
            if (this.logExportService.isEnabled()) {
                this.logExportService.export((LogRecord)record);
            }
        }
    }
}

