/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.asyncprofiler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage.AsyncProfilerTaskRecord;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerEventType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskCreationResult;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskCreationType;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class AsyncProfilerMutationService
implements Service {
    private final ModuleManager moduleManager;
    private IAsyncProfilerTaskQueryDAO taskQueryDAO;

    private IAsyncProfilerTaskQueryDAO getAsyncProfileTaskDAO() {
        if (this.taskQueryDAO == null) {
            this.taskQueryDAO = (IAsyncProfilerTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IAsyncProfilerTaskQueryDAO.class);
        }
        return this.taskQueryDAO;
    }

    public AsyncProfilerTaskCreationResult createTask(String serviceId, List<String> serviceInstanceIds, int duration, List<AsyncProfilerEventType> events, String execArgs) throws IOException {
        long createTime = System.currentTimeMillis();
        AsyncProfilerTaskCreationResult checkResult = this.checkDataSuccess(serviceId, serviceInstanceIds, duration, createTime, events);
        if (checkResult != null) {
            return checkResult;
        }
        AsyncProfilerTaskRecord task = new AsyncProfilerTaskRecord();
        task.setTaskId(createTime + "_" + serviceId);
        task.setServiceId(serviceId);
        task.setServiceInstanceIdsFromList(serviceInstanceIds);
        task.setDuration(duration);
        List<String> rowEvents = events.stream().map(Enum::toString).collect(Collectors.toList());
        task.setEventsFromList(rowEvents);
        task.setCreateTime(createTime);
        task.setExecArgs(execArgs);
        task.setTimeBucket(TimeBucket.getRecordTimeBucket(createTime));
        NoneStreamProcessor.getInstance().in(task);
        return AsyncProfilerTaskCreationResult.builder().id(task.id().build()).code(AsyncProfilerTaskCreationType.SUCCESS).build();
    }

    private AsyncProfilerTaskCreationResult checkDataSuccess(String serviceId, List<String> serviceInstanceIds, int duration, long createTime, List<AsyncProfilerEventType> events) throws IOException {
        String checkArgumentMessage = this.checkArgumentError(serviceId, serviceInstanceIds, duration, events);
        if (checkArgumentMessage != null) {
            return AsyncProfilerTaskCreationResult.builder().code(AsyncProfilerTaskCreationType.ARGUMENT_ERROR).errorReason(checkArgumentMessage).build();
        }
        String checkTaskProfilingMessage = this.checkTaskProfiling(serviceId, createTime);
        if (checkTaskProfilingMessage != null) {
            return AsyncProfilerTaskCreationResult.builder().code(AsyncProfilerTaskCreationType.ALREADY_PROFILING_ERROR).errorReason(checkTaskProfilingMessage).build();
        }
        return null;
    }

    private String checkArgumentError(String serviceId, List<String> serviceInstanceIds, int duration, List<AsyncProfilerEventType> events) {
        if (serviceId == null) {
            return "service cannot be null";
        }
        if (duration <= 0) {
            return "duration cannot be negative";
        }
        if (CollectionUtils.isEmpty(events)) {
            return "events cannot be empty";
        }
        if (CollectionUtils.isEmpty(serviceInstanceIds)) {
            return "serviceInstanceIds cannot be empty";
        }
        return null;
    }

    private String checkTaskProfiling(String serviceId, long createTime) throws IOException {
        long endTimeBucket = TimeBucket.getMinuteTimeBucket(createTime);
        List<AsyncProfilerTask> alreadyHaveTaskList = this.getAsyncProfileTaskDAO().getTaskList(serviceId, null, endTimeBucket, 1);
        if (CollectionUtils.isNotEmpty(alreadyHaveTaskList)) {
            for (AsyncProfilerTask task : alreadyHaveTaskList) {
                if (task.getCreateTime() + TimeUnit.SECONDS.toMillis(task.getDuration()) < createTime) continue;
                return "current service already has monitor async profiler task execute at this time";
            }
        }
        return null;
    }

    @Generated
    public AsyncProfilerMutationService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

