/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessTraffic;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.profiling.ebpf.analyze.EBPFProfilingAnalyzer;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeAggregateType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskContinuousProfiling;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskExtension;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskPrepare;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.StorageModels;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBPFProfilingQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EBPFProfilingQueryService.class);
    private static final Gson GSON = new Gson();
    private final ModuleManager moduleManager;
    private final CoreModuleConfig config;
    private final StorageModels storageModels;
    private IMetadataQueryDAO metadataQueryDAO;
    private IServiceLabelDAO serviceLabelDAO;
    private IEBPFProfilingTaskDAO taskDAO;
    private IEBPFProfilingScheduleDAO scheduleDAO;
    private EBPFProfilingAnalyzer profilingAnalyzer;
    private IMetricsDAO processMetricsDAO;
    private Model processTrafficModel;

    private IEBPFProfilingTaskDAO getTaskDAO() {
        if (this.taskDAO == null) {
            this.taskDAO = (IEBPFProfilingTaskDAO)this.moduleManager.find("storage").provider().getService(IEBPFProfilingTaskDAO.class);
        }
        return this.taskDAO;
    }

    private IEBPFProfilingScheduleDAO getScheduleDAO() {
        if (this.scheduleDAO == null) {
            this.scheduleDAO = (IEBPFProfilingScheduleDAO)this.moduleManager.find("storage").provider().getService(IEBPFProfilingScheduleDAO.class);
        }
        return this.scheduleDAO;
    }

    private IMetricsDAO getProcessMetricsDAO() {
        if (this.processMetricsDAO == null) {
            StorageDAO storageDAO = (StorageDAO)this.moduleManager.find("storage").provider().getService(StorageDAO.class);
            this.processMetricsDAO = storageDAO.newMetricsDao(new ProcessTraffic.Builder());
        }
        return this.processMetricsDAO;
    }

    private Model getProcessModel() {
        if (this.processTrafficModel == null) {
            for (Model model : this.storageModels.allModels()) {
                if (!Objects.equals(model.getName(), "process_traffic")) continue;
                this.processTrafficModel = model;
                break;
            }
            if (this.processTrafficModel == null) {
                throw new IllegalStateException("could not found the process traffic model");
            }
        }
        return this.processTrafficModel;
    }

    private EBPFProfilingAnalyzer getProfilingAnalyzer() {
        if (this.profilingAnalyzer == null) {
            this.profilingAnalyzer = new EBPFProfilingAnalyzer(this.moduleManager, this.config.getMaxDurationOfQueryEBPFProfilingData(), this.config.getMaxThreadCountOfQueryEBPFProfilingData());
        }
        return this.profilingAnalyzer;
    }

    public IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    public IServiceLabelDAO getServiceLabelDAO() {
        if (this.serviceLabelDAO == null) {
            this.serviceLabelDAO = (IServiceLabelDAO)this.moduleManager.find("storage").provider().getService(IServiceLabelDAO.class);
        }
        return this.serviceLabelDAO;
    }

    public EBPFProfilingTaskPrepare queryPrepareCreateEBPFProfilingTaskData(String serviceId) throws IOException {
        EBPFProfilingTaskPrepare prepare = new EBPFProfilingTaskPrepare();
        long endTimestamp = System.currentTimeMillis();
        long startTimestamp = endTimestamp - TimeUnit.MINUTES.toMillis(10L);
        long processesCount = this.getMetadataQueryDAO().getProcessCount(serviceId, ProfilingSupportStatus.SUPPORT_EBPF_PROFILING, TimeBucket.getTimeBucket(startTimestamp, DownSampling.Minute), TimeBucket.getTimeBucket(endTimestamp, DownSampling.Minute));
        if (processesCount <= 0L) {
            prepare.setCouldProfiling(false);
            prepare.setProcessLabels(Collections.emptyList());
            return prepare;
        }
        prepare.setCouldProfiling(true);
        List<String> processLabels = this.getServiceLabelDAO().queryAllLabels(serviceId);
        if (processLabels != null && !processLabels.isEmpty()) {
            prepare.setProcessLabels(processLabels.stream().distinct().collect(Collectors.toList()));
        } else {
            prepare.setProcessLabels(Collections.emptyList());
        }
        return prepare;
    }

    public List<EBPFProfilingTask> queryEBPFProfilingTasks(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targets, EBPFProfilingTriggerType triggerType, Duration duration) throws IOException {
        if (CollectionUtils.isEmpty(targets)) {
            targets = Arrays.asList(EBPFProfilingTargetType.values());
        }
        long startTime = 0L;
        long endTime = 0L;
        if (duration != null) {
            startTime = duration.getStartTimestamp();
            endTime = duration.getEndTimestamp();
        }
        List<EBPFProfilingTaskRecord> tasks = this.getTaskDAO().queryTasksByTargets(serviceId, serviceInstanceId, targets, triggerType, startTime, endTime);
        Map records = tasks.stream().collect(Collectors.toMap(EBPFProfilingTaskRecord::getLogicalId, Function.identity(), EBPFProfilingTaskRecord::combine));
        return records.values().stream().map(this::parseTask).sorted((o1, o2) -> -Long.compare(o1.getCreateTime(), o2.getCreateTime())).collect(Collectors.toList());
    }

    private EBPFProfilingTask parseTask(EBPFProfilingTaskRecord record) {
        EBPFProfilingTask result = new EBPFProfilingTask();
        result.setTaskId(record.getLogicalId());
        result.setServiceId(record.getServiceId());
        result.setServiceName(IDManager.ServiceID.analysisId(record.getServiceId()).getName());
        if (StringUtil.isNotEmpty((String)record.getProcessLabelsJson())) {
            result.setProcessLabels((List)GSON.fromJson(record.getProcessLabelsJson(), ArrayList.class));
        } else {
            result.setProcessLabels(Collections.emptyList());
        }
        if (StringUtil.isNotEmpty((String)record.getInstanceId())) {
            result.setServiceInstanceId(record.getInstanceId());
            result.setServiceInstanceName(IDManager.ServiceInstanceID.analysisId(record.getInstanceId()).getName());
        }
        result.setTaskStartTime(record.getStartTime());
        result.setTriggerType(EBPFProfilingTriggerType.valueOf(record.getTriggerType()));
        result.setFixedTriggerDuration(record.getFixedTriggerDuration());
        result.setTargetType(EBPFProfilingTargetType.valueOf(record.getTargetType()));
        result.setCreateTime(record.getCreateTime());
        result.setLastUpdateTime(record.getLastUpdateTime());
        if (StringUtil.isNotEmpty((String)record.getExtensionConfigJson())) {
            result.setExtensionConfig((EBPFProfilingTaskExtension)GSON.fromJson(record.getExtensionConfigJson(), EBPFProfilingTaskExtension.class));
        }
        if (StringUtil.isNotEmpty((String)record.getContinuousProfilingJson())) {
            EBPFProfilingTaskContinuousProfiling continuousProfiling = (EBPFProfilingTaskContinuousProfiling)GSON.fromJson(record.getContinuousProfilingJson(), EBPFProfilingTaskContinuousProfiling.class);
            result.setProcessId(continuousProfiling.getProcessId());
            result.setProcessName(continuousProfiling.getProcessName());
            result.setContinuousProfilingCauses(continuousProfiling.getCauses());
        }
        return result;
    }

    public List<EBPFProfilingSchedule> queryEBPFProfilingSchedules(String taskId) throws Exception {
        List<EBPFProfilingSchedule> schedules = this.getScheduleDAO().querySchedules(taskId);
        log.info("schedules: {}", (Object)GSON.toJson(schedules));
        if (CollectionUtils.isNotEmpty(schedules)) {
            Model processModel = this.getProcessModel();
            List<Metrics> processMetrics = schedules.stream().map(EBPFProfilingSchedule::getProcessId).distinct().map(processId -> {
                ProcessTraffic p = new ProcessTraffic();
                p.setProcessId((String)processId);
                return p;
            }).collect(Collectors.toList());
            List<Metrics> processes = this.getProcessMetricsDAO().multiGet(processModel, processMetrics);
            log.info("processes: {}", (Object)GSON.toJson(processes));
            Map<String, Process> processMap = processes.stream().map(t -> (ProcessTraffic)t).collect(Collectors.toMap(m -> m.id().build(), this::convertProcess));
            schedules.forEach(p -> p.setProcess((Process)processMap.get(p.getProcessId())));
        }
        return schedules;
    }

    public EBPFProfilingAnalyzation getEBPFProfilingAnalyzation(List<String> scheduleIdList, List<EBPFProfilingAnalyzeTimeRange> timeRanges, EBPFProfilingAnalyzeAggregateType aggregateType) throws IOException {
        return this.getProfilingAnalyzer().analyze(scheduleIdList, timeRanges, aggregateType);
    }

    private Process convertProcess(ProcessTraffic traffic) {
        Process process = new Process();
        process.setId(traffic.id().build());
        process.setName(traffic.getName());
        String serviceId = traffic.getServiceId();
        process.setServiceId(serviceId);
        process.setServiceName(IDManager.ServiceID.analysisId(serviceId).getName());
        String instanceId = traffic.getInstanceId();
        process.setInstanceId(instanceId);
        process.setInstanceName(IDManager.ServiceInstanceID.analysisId(instanceId).getName());
        process.setAgentId(traffic.getAgentId());
        process.setDetectType(ProcessDetectType.valueOf(traffic.getDetectType()).name());
        if (traffic.getProperties() != null) {
            for (String key : traffic.getProperties().keySet()) {
                process.getAttributes().add(new Attribute(key, traffic.getProperties().get(key).getAsString()));
            }
        }
        if (StringUtil.isNotEmpty((String)traffic.getLabelsJson())) {
            process.getLabels().addAll((Collection)GSON.fromJson(traffic.getLabelsJson(), ArrayList.class));
        }
        return process;
    }

    @Generated
    public EBPFProfilingQueryService(ModuleManager moduleManager, CoreModuleConfig config, StorageModels storageModels) {
        this.moduleManager = moduleManager;
        this.config = config;
        this.storageModels = storageModels;
    }
}

