/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.server.auth;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;

public class AuthenticationInterceptor
implements ServerInterceptor {
    private String expectedToken = "";
    private ServerCall.Listener listener = new ServerCall.Listener(){};
    private static final Metadata.Key<String> AUTH_HEAD_HEADER_NAME = Metadata.Key.of((String)"Authentication", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public AuthenticationInterceptor(String expectedToken) {
        this.expectedToken = expectedToken;
    }

    public void setExpectedToken(String expectedToken) {
        this.expectedToken = expectedToken;
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> serverCall, Metadata metadata, ServerCallHandler<REQUEST, RESPONSE> serverCallHandler) {
        String token = (String)metadata.get(AUTH_HEAD_HEADER_NAME);
        if (this.expectedToken.equals(token)) {
            return serverCallHandler.startCall(serverCall, metadata);
        }
        serverCall.close(Status.PERMISSION_DENIED, new Metadata());
        return this.listener;
    }
}

