/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;

public class SQLDatabaseModelExtension {
    private final Map<String, AdditionalTable> additionalTables = new HashMap<String, AdditionalTable>(5);
    private final List<ModelColumn> excludeColumns = new ArrayList<ModelColumn>(5);

    public void appendAdditionalTable(String tableName, ModelColumn column) {
        this.additionalTables.computeIfAbsent(tableName, x$0 -> new AdditionalTable((String)x$0)).appendColumn(column);
    }

    public void appendExcludeColumns(ModelColumn column) {
        this.excludeColumns.add(column);
    }

    @Generated
    public Map<String, AdditionalTable> getAdditionalTables() {
        return this.additionalTables;
    }

    @Generated
    public List<ModelColumn> getExcludeColumns() {
        return this.excludeColumns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLDatabaseModelExtension)) {
            return false;
        }
        SQLDatabaseModelExtension other = (SQLDatabaseModelExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, AdditionalTable> this$additionalTables = this.getAdditionalTables();
        Map<String, AdditionalTable> other$additionalTables = other.getAdditionalTables();
        if (this$additionalTables == null ? other$additionalTables != null : !((Object)this$additionalTables).equals(other$additionalTables)) {
            return false;
        }
        List<ModelColumn> this$excludeColumns = this.getExcludeColumns();
        List<ModelColumn> other$excludeColumns = other.getExcludeColumns();
        return !(this$excludeColumns == null ? other$excludeColumns != null : !((Object)this$excludeColumns).equals(other$excludeColumns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLDatabaseModelExtension;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, AdditionalTable> $additionalTables = this.getAdditionalTables();
        result = result * 59 + ($additionalTables == null ? 43 : ((Object)$additionalTables).hashCode());
        List<ModelColumn> $excludeColumns = this.getExcludeColumns();
        result = result * 59 + ($excludeColumns == null ? 43 : ((Object)$excludeColumns).hashCode());
        return result;
    }

    public static class AdditionalTable {
        private final String name;
        private final List<ModelColumn> columns = new ArrayList<ModelColumn>();
        private boolean hasListColumn = false;

        public void appendColumn(ModelColumn column) {
            if (this.hasListColumn && List.class.isAssignableFrom(column.getType())) {
                throw new IllegalStateException("A AdditionalEntity: " + this.name + " only support 1 List type. Field: " + column.getColumnName() + " should set to another AdditionalEntity.");
            }
            if (List.class.isAssignableFrom(column.getType())) {
                this.hasListColumn = true;
            }
            this.columns.add(column);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<ModelColumn> getColumns() {
            return this.columns;
        }

        @Generated
        public boolean isHasListColumn() {
            return this.hasListColumn;
        }

        @Generated
        private AdditionalTable(String name) {
            this.name = name;
        }
    }
}

