/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.Service;

public interface ILogQueryDAO
extends Service {
    default public boolean supportQueryLogsByKeywords() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Logs queryLogsDebuggable(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, Duration duration, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: queryLogs");
                StringBuilder msg = new StringBuilder();
                msg.append("ServiceId: ").append(serviceId).append(", ServiceInstanceId: ").append(serviceInstanceId).append(", EndpointId: ").append(endpointId).append(", RelatedTrace: ").append(relatedTrace).append(", QueryOrder: ").append((Object)queryOrder).append(", From: ").append(from).append(", Limit: ").append(limit).append(", Duration: ").append(duration).append(", Tags: ").append(tags).append(", KeywordsOfContent: ").append(keywordsOfContent).append(", ExcludingKeywordsOfContent: ").append(excludingKeywordsOfContent);
                span.setMsg(msg.toString());
            }
            Logs logs = this.queryLogs(serviceId, serviceInstanceId, endpointId, relatedTrace, queryOrder, from, limit, duration, tags, keywordsOfContent, excludingKeywordsOfContent);
            return logs;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    public Logs queryLogs(String var1, String var2, String var3, TraceScopeCondition var4, Order var5, int var6, int var7, Duration var8, List<Tag> var9, List<String> var10, List<String> var11) throws IOException;

    default public void parserDataBinary(String dataBinaryBase64, List<KeyValue> tags) {
        this.parserDataBinary(Base64.getDecoder().decode(dataBinaryBase64), tags);
    }

    default public void parserDataBinary(byte[] dataBinary, List<KeyValue> tags) {
        try {
            LogTags logTags = LogTags.parseFrom((byte[])dataBinary);
            logTags.getDataList().forEach(pair -> tags.add(new KeyValue(pair.getKey(), pair.getValue())));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }
}

