/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.grammar.MQEParserBaseVisitor;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class LogicalFunctionOp {
    public static ExpressionResult doOP(int opType, MQEParser.ExpressionListContext expressionListContext, MQEParserBaseVisitor<ExpressionResult> visitor) throws IllegalExpressionException {
        switch (opType) {
            case 39: {
                return LogicalFunctionOp.viewAsSeq(expressionListContext, visitor);
            }
            case 40: {
                return LogicalFunctionOp.isPresent(expressionListContext, visitor);
            }
        }
        throw new IllegalExpressionException("Unsupported function.");
    }

    private static ExpressionResult viewAsSeq(MQEParser.ExpressionListContext expressionListContext, MQEParserBaseVisitor<ExpressionResult> visitor) {
        ExpressionResult firstResult = null;
        for (MQEParser.ExpressionContext expContext : expressionListContext.expression()) {
            boolean isNotEmptyValue;
            ExpressionResult result = (ExpressionResult)visitor.visit((ParseTree)expContext);
            if (firstResult == null) {
                firstResult = result;
            }
            if (result == null || CollectionUtils.isEmpty((List)result.getResults()) || !(isNotEmptyValue = result.getResults().stream().filter(s -> s != null && CollectionUtils.isNotEmpty((List)s.getValues())).flatMap(s -> s.getValues().stream()).anyMatch(s -> !s.isEmptyValue()))) continue;
            return result;
        }
        return firstResult;
    }

    private static ExpressionResult isPresent(MQEParser.ExpressionListContext expressionListContext, MQEParserBaseVisitor<ExpressionResult> visitor) {
        boolean present = false;
        for (MQEParser.ExpressionContext expContext : expressionListContext.expression()) {
            ExpressionResult result = (ExpressionResult)visitor.visit((ParseTree)expContext);
            if (result != null) {
                present = result.getResults().stream().filter(Objects::nonNull).anyMatch(r -> r.getValues().stream().anyMatch(v -> !v.isEmptyValue()));
            }
            if (!present) continue;
            break;
        }
        ExpressionResult result = new ExpressionResult();
        result.setType(ExpressionResultType.SINGLE_VALUE);
        MQEValue mqeValue = new MQEValue();
        MQEValues mqeValues = new MQEValues();
        mqeValues.getValues().add(mqeValue);
        result.getResults().add(mqeValues);
        mqeValue.setDoubleValue(present ? 1.0 : 0.0);
        mqeValue.setEmptyValue(false);
        return result;
    }
}

