/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortLabelValuesOp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SortLabelValuesOp.class);

    public static ExpressionResult doSortLabelValuesOp(ExpressionResult expResult, int order, List<String> labelNames) throws IllegalExpressionException {
        if (CollectionUtils.isNotEmpty(labelNames)) {
            labelNames = labelNames.stream().distinct().collect(Collectors.toList());
            if (42 == order) {
                expResult.setResults(SortLabelValuesOp.sort(expResult.getResults(), labelNames, labelNames.get(0), Comparator.naturalOrder()));
            } else if (43 == order) {
                expResult.setResults(SortLabelValuesOp.sort(expResult.getResults(), labelNames, labelNames.get(0), Comparator.reverseOrder()));
            } else {
                throw new IllegalExpressionException("Unsupported sort order.");
            }
        }
        return expResult;
    }

    private static List<MQEValues> sort(List<MQEValues> results, List<String> sortLabels, String currentSortLabel, Comparator<String> comparator) {
        if (!sortLabels.contains(currentSortLabel)) {
            log.error("Current sort label {} not found in the sort labels {} ", (Object)currentSortLabel, sortLabels);
            return results;
        }
        if (sortLabels.indexOf(currentSortLabel) == sortLabels.size() - 1) {
            results.sort(Comparator.comparing(mqeValues -> mqeValues.getMetric().getLabels().stream().filter(kv -> kv.getKey().equals(currentSortLabel)).findFirst().orElse(new KeyValue(currentSortLabel, "")).getValue(), comparator));
        } else {
            LinkedHashMap<KeyValue, List<MQEValues>> groupResult = SortLabelValuesOp.group(results, currentSortLabel);
            LinkedHashMap<KeyValue, List<MQEValues>> sortedGroup = new LinkedHashMap<KeyValue, List<MQEValues>>(groupResult.size());
            for (Map.Entry<KeyValue, List<MQEValues>> entry : groupResult.entrySet()) {
                List<MQEValues> sortedResult = SortLabelValuesOp.sort(entry.getValue(), sortLabels, sortLabels.get(sortLabels.indexOf(currentSortLabel) + 1), comparator);
                sortedGroup.put(entry.getKey(), sortedResult);
            }
            results = sortedGroup.keySet().stream().sorted(Comparator.comparing(KeyValue::getValue, comparator)).flatMap(keyValue -> ((List)sortedGroup.get(keyValue)).stream()).collect(Collectors.toList());
        }
        return results;
    }

    private static LinkedHashMap<KeyValue, List<MQEValues>> group(List<MQEValues> results, String labelName) {
        return results.stream().collect(Collectors.groupingBy(mqeValues -> mqeValues.getMetric().getLabels().stream().filter(kv -> kv.getKey().equals(labelName)).findFirst().orElse(new KeyValue(labelName, "")), LinkedHashMap::new, Collectors.toList()));
    }
}

