/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.identify;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.client.auth.ram.identify.StsConfig;
import com.alibaba.nacos.client.auth.ram.identify.StsCredential;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import org.slf4j.Logger;

public class StsCredentialHolder {
    private static final Logger LOGGER = LogUtils.logger(StsCredentialHolder.class);
    private static final StsCredentialHolder INSTANCE = new StsCredentialHolder();
    private StsCredential stsCredential;

    private StsCredentialHolder() {
    }

    public static StsCredentialHolder getInstance() {
        return INSTANCE;
    }

    public StsCredential getStsCredential() {
        boolean cacheSecurityCredentials = StsConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.stsCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.stsCredential.getExpiration().getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = StsConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.stsCredential;
            }
        }
        String stsResponse = StsCredentialHolder.getStsResponse();
        this.stsCredential = JacksonUtils.toObj(stsResponse, new TypeReference<StsCredential>(){});
        LOGGER.info("[getSTSCredential] code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", new Object[]{this.stsCredential.getCode(), this.stsCredential.getAccessKeyId(), this.stsCredential.getLastUpdated(), this.stsCredential.getExpiration()});
        return this.stsCredential;
    }

    private static String getStsResponse() {
        String securityCredentials = StsConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = StsConfig.getInstance().getSecurityCredentialsUrl();
        try {
            HttpRestResult result = ConfigHttpClientManager.getInstance().getNacosRestTemplate().get(securityCredentialsUrl, Header.EMPTY, Query.EMPTY, (Type)((Object)String.class));
            if (!result.ok()) {
                LOGGER.error("can not get security credentials, securityCredentialsUrl: {}, responseCode: {}, response: {}", new Object[]{securityCredentialsUrl, result.getCode(), result.getMessage()});
                throw new NacosRuntimeException(500, "can not get security credentials, responseCode: " + result.getCode() + ", response: " + result.getMessage());
            }
            return (String)result.getData();
        }
        catch (Exception e) {
            LOGGER.error("can not get security credentials", (Throwable)e);
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }
}

