/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCProfileTaskQueryDAO
implements IProfileTaskQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public JDBCProfileTaskQueryDAO(JDBCClient jdbcClient, ModuleManager moduleManager) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = new TableHelper(moduleManager, jdbcClient);
    }

    public List<ProfileTask> getTaskList(String serviceId, String endpointName, Long startTimeBucket, Long endTimeBucket, Integer limit) {
        ArrayList<ProfileTask> results = new ArrayList<ProfileTask>();
        List<String> tables = startTimeBucket == null || endTimeBucket == null ? this.tableHelper.getTablesWithinTTL("profile_task") : this.tableHelper.getTablesForRead("profile_task", startTimeBucket, endTimeBucket);
        for (String table : tables) {
            ArrayList<Object> condition = new ArrayList<Object>(4);
            StringBuilder sql = new StringBuilder().append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("profile_task");
            if (startTimeBucket != null) {
                sql.append(" and ").append("time_bucket").append(" >= ? ");
                condition.add(startTimeBucket);
            }
            if (endTimeBucket != null) {
                sql.append(" and ").append("time_bucket").append(" <= ? ");
                condition.add(endTimeBucket);
            }
            if (StringUtil.isNotEmpty((String)serviceId)) {
                sql.append(" and ").append("service_id").append("=? ");
                condition.add(serviceId);
            }
            if (StringUtil.isNotEmpty((String)endpointName)) {
                sql.append(" and ").append("endpoint_name").append("=?");
                condition.add(endpointName);
            }
            sql.append(" ORDER BY ").append("start_time").append(" DESC ");
            if (limit != null) {
                sql.append(" LIMIT ").append(limit);
            }
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                ArrayList<ProfileTask> tasks = new ArrayList<ProfileTask>();
                while (resultSet.next()) {
                    tasks.add(this.parseTask(resultSet));
                }
                return tasks;
            }, condition.toArray(new Object[0])));
        }
        return limit == null ? results : results.stream().limit(limit.intValue()).collect(Collectors.toList());
    }

    public ProfileTask getById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        List<String> tables = this.tableHelper.getTablesWithinTTL("profile_task");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ").append(" and ").append("task_id=? LIMIT 1");
            condition.add("profile_task");
            condition.add(id);
            ProfileTask r = (ProfileTask)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (resultSet.next()) {
                    return this.parseTask(resultSet);
                }
                return null;
            }, condition.toArray(new Object[0]));
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private ProfileTask parseTask(ResultSet data) throws SQLException {
        return ProfileTask.builder().id(data.getString("task_id")).serviceId(data.getString("service_id")).endpointName(data.getString("endpoint_name")).startTime(data.getLong("start_time")).createTime(data.getLong("create_time")).duration(data.getInt("duration")).minDurationThreshold(data.getInt("min_duration_threshold")).dumpPeriod(data.getInt("dump_period")).maxSamplingCount(data.getInt("max_sampling_count")).build();
    }
}

