/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCSpanAttachedEventQueryDAO
implements ISpanAttachedEventQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<SpanAttachedEventRecord> querySpanAttachedEvents(SpanAttachedEventTraceType type, List<String> traceIds) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("span_attached_event_record");
        ArrayList results = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = JDBCSpanAttachedEventQueryDAO.buildSQL(type, traceIds, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    SpanAttachedEventRecord record = new SpanAttachedEventRecord();
                    record.setStartTimeSecond(resultSet.getLong("start_time_second"));
                    record.setStartTimeNanos(resultSet.getInt("start_time_nanos"));
                    record.setEvent(resultSet.getString("event"));
                    record.setEndTimeSecond(resultSet.getLong("end_time_second"));
                    record.setEndTimeNanos(resultSet.getInt("end_time_nanos"));
                    record.setTraceRefType(resultSet.getInt("trace_ref_type"));
                    record.setRelatedTraceId(resultSet.getString("related_trace_id"));
                    record.setTraceSegmentId(resultSet.getString("trace_segment_id"));
                    record.setTraceSpanId(resultSet.getString("trace_span_id"));
                    String dataBinaryBase64 = resultSet.getString("data_binary");
                    if (StringUtil.isNotEmpty((String)dataBinaryBase64)) {
                        record.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
                    }
                    results.add(record);
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        return results.stream().sorted(Comparator.comparing(SpanAttachedEventRecord::getStartTimeSecond).thenComparing(SpanAttachedEventRecord::getStartTimeNanos)).collect(Collectors.toList());
    }

    private static SQLAndParameters buildSQL(SpanAttachedEventTraceType type, List<String> traceIds, String table) {
        StringBuilder sql = new StringBuilder("select * from " + table + " where ");
        ArrayList<Object> parameters = new ArrayList<Object>(traceIds.size() + 1);
        sql.append("table_name").append(" = ? ");
        parameters.add("span_attached_event_record");
        sql.append(" and ").append("related_trace_id").append(" in ");
        sql.append(traceIds.stream().map(it -> "?").collect(Collectors.joining(",", "(", ")")));
        parameters.addAll(traceIds);
        sql.append(" and ").append("trace_ref_type").append(" = ?");
        parameters.add(type.value());
        sql.append(" order by ").append("start_time_second").append(",").append("start_time_nanos").append(" ASC ");
        return new SQLAndParameters(sql.toString(), parameters);
    }

    @Generated
    public JDBCSpanAttachedEventQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

