/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListenerFactory;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EntryAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.FirstAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.SegmentListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.TraceSegmentSampler;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.strategy.SegmentStatusAnalyzer;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.strategy.SegmentStatusStrategy;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.config.SearchableTracesTagsWatcher;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.Segment;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.source.TagAutocomplete;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentAnalysisListener
implements FirstAnalysisListener,
EntryAnalysisListener,
SegmentListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentAnalysisListener.class);
    private final SourceReceiver sourceReceiver;
    private final TraceSegmentSampler sampler;
    private final boolean forceSampleErrorSegment;
    private final NamingControl namingControl;
    private final SearchableTracesTagsWatcher searchableTagKeys;
    private final SegmentStatusAnalyzer segmentStatusAnalyzer;
    private final Segment segment = new Segment();
    private SAMPLE_STATUS sampleStatus = SAMPLE_STATUS.UNKNOWN;
    private String serviceName = "";
    private String serviceId = "";
    private String endpointId = "";
    private String endpointName = "";
    private long startTimestamp;
    private long endTimestamp;
    private int duration;
    private boolean isError;

    @Override
    public boolean containsPoint(AnalysisListener.Point point) {
        return AnalysisListener.Point.First.equals((Object)point) || AnalysisListener.Point.Entry.equals((Object)point) || AnalysisListener.Point.Segment.equals((Object)point);
    }

    @Override
    public void parseFirst(SpanObject span, SegmentObject segmentObject) {
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            return;
        }
        if (StringUtil.isEmpty((String)this.serviceId)) {
            this.serviceName = this.namingControl.formatServiceName(segmentObject.getService());
            this.serviceId = IDManager.ServiceID.buildId((String)this.serviceName, (boolean)true);
        }
        long timeBucket = TimeBucket.getRecordTimeBucket((long)this.startTimestamp);
        this.segment.setSegmentId(segmentObject.getTraceSegmentId());
        this.segment.setServiceId(this.serviceId);
        this.segment.setServiceInstanceId(IDManager.ServiceInstanceID.buildId((String)this.serviceId, (String)this.namingControl.formatInstanceName(segmentObject.getServiceInstance())));
        this.segment.setLatency(this.duration);
        this.segment.setStartTime(this.startTimestamp);
        this.segment.setTimeBucket(timeBucket);
        this.segment.setIsError(BooleanUtils.booleanToValue((Boolean)this.isError));
        this.segment.setDataBinary(segmentObject.toByteArray());
        this.endpointName = this.namingControl.formatEndpointName(this.serviceName, span.getOperationName());
        this.endpointId = IDManager.EndpointID.buildId((String)this.serviceId, (String)this.endpointName);
    }

    @Override
    public void parseEntry(SpanObject span, SegmentObject segmentObject) {
        if (StringUtil.isEmpty((String)this.serviceId)) {
            this.serviceName = this.namingControl.formatServiceName(segmentObject.getService());
            this.serviceId = IDManager.ServiceID.buildId((String)this.serviceName, (boolean)true);
        }
        this.endpointName = this.namingControl.formatEndpointName(this.serviceName, span.getOperationName());
        this.endpointId = IDManager.EndpointID.buildId((String)this.serviceId, (String)this.endpointName);
    }

    @Override
    public void parseSegment(SegmentObject segmentObject) {
        this.segment.setTraceId(segmentObject.getTraceId());
        segmentObject.getSpansList().forEach(span -> {
            if (this.startTimestamp == 0L || this.startTimestamp > span.getStartTime()) {
                this.startTimestamp = span.getStartTime();
            }
            if (span.getEndTime() > this.endTimestamp) {
                this.endTimestamp = span.getEndTime();
            }
            this.isError = this.isError || this.segmentStatusAnalyzer.isError((SpanObject)span);
            this.appendSearchableTags((SpanObject)span);
        });
        long accurateDuration = this.endTimestamp - this.startTimestamp;
        int n = this.duration = accurateDuration > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)accurateDuration;
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.UNKNOWN) || this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            this.sampleStatus = this.sampler.shouldSample(segmentObject, this.duration) ? SAMPLE_STATUS.SAMPLED : (this.isError && this.forceSampleErrorSegment ? SAMPLE_STATUS.SAMPLED : SAMPLE_STATUS.IGNORE);
        }
    }

    private void appendSearchableTags(SpanObject span) {
        span.getTagsList().forEach(tag -> {
            if (this.searchableTagKeys.getSearchableTags().contains(tag.getKey())) {
                Tag spanTag = new Tag(tag.getKey(), tag.getValue());
                if (tag.getValue().length() > 256 || spanTag.toString().length() > 256) {
                    if (log.isDebugEnabled()) {
                        log.debug("Segment tag : {} length > : {}, dropped", (Object)spanTag, (Object)256);
                    }
                    return;
                }
                if (!this.segment.getTags().contains(spanTag)) {
                    this.segment.getTags().add(spanTag);
                }
            }
        });
    }

    @Override
    public void build() {
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            if (log.isDebugEnabled()) {
                log.debug("segment ignored, trace id: {}", (Object)this.segment.getTraceId());
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("segment listener build, segment id: {}", (Object)this.segment.getSegmentId());
        }
        this.segment.setEndpointId(this.endpointId);
        this.sourceReceiver.receive((ISource)this.segment);
        this.addAutocompleteTags();
    }

    private void addAutocompleteTags() {
        this.segment.getTags().forEach(tag -> {
            TagAutocomplete tagAutocomplete = new TagAutocomplete();
            tagAutocomplete.setTagKey(tag.getKey());
            tagAutocomplete.setTagValue(tag.getValue());
            tagAutocomplete.setTagType(TagType.TRACE);
            tagAutocomplete.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)this.segment.getStartTime()));
            this.sourceReceiver.receive((ISource)tagAutocomplete);
        });
    }

    @Generated
    public SegmentAnalysisListener(SourceReceiver sourceReceiver, TraceSegmentSampler sampler, boolean forceSampleErrorSegment, NamingControl namingControl, SearchableTracesTagsWatcher searchableTagKeys, SegmentStatusAnalyzer segmentStatusAnalyzer) {
        this.sourceReceiver = sourceReceiver;
        this.sampler = sampler;
        this.forceSampleErrorSegment = forceSampleErrorSegment;
        this.namingControl = namingControl;
        this.searchableTagKeys = searchableTagKeys;
        this.segmentStatusAnalyzer = segmentStatusAnalyzer;
    }

    private static enum SAMPLE_STATUS {
        UNKNOWN,
        SAMPLED,
        IGNORE;

    }

    public static class Factory
    implements AnalysisListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final TraceSegmentSampler sampler;
        private final boolean forceSampleErrorSegment;
        private final NamingControl namingControl;
        private final SearchableTracesTagsWatcher searchTagKeys;
        private final SegmentStatusAnalyzer segmentStatusAnalyzer;

        public Factory(ModuleManager moduleManager, AnalyzerModuleConfig config) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            ConfigService configService = (ConfigService)moduleManager.find("core").provider().getService(ConfigService.class);
            this.searchTagKeys = configService.getSearchableTracesTags();
            this.sampler = new TraceSegmentSampler(config.getTraceSamplingPolicyWatcher());
            this.forceSampleErrorSegment = config.isForceSampleErrorSegment();
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
            this.segmentStatusAnalyzer = SegmentStatusStrategy.findByName(config.getSegmentStatusAnalysisStrategy()).getExceptionAnalyzer();
        }

        @Override
        public AnalysisListener create(ModuleManager moduleManager, AnalyzerModuleConfig config) {
            return new SegmentAnalysisListener(this.sourceReceiver, this.sampler, this.forceSampleErrorSegment, this.namingControl, this.searchTagKeys, this.segmentStatusAnalyzer);
        }
    }
}

