/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel.otlp;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.vavr.Function1;
import io.vavr.control.Try;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.MetricRuleConfig;
import org.apache.skywalking.oap.meter.analyzer.prometheus.PrometheusMetricConverter;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rules;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryMetricRequestProcessor
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryMetricRequestProcessor.class);
    private final ModuleManager manager;
    private final OtelMetricReceiverConfig config;
    private static final Map<String, String> LABEL_MAPPINGS = ImmutableMap.builder().put((Object)"net.host.name", (Object)"node_identifier_host_name").put((Object)"host.name", (Object)"node_identifier_host_name").put((Object)"job", (Object)"job_name").put((Object)"service.name", (Object)"job_name").build();
    private List<MetricConvert> converters;
    private final AtomicReference<Object> metricsCreator = new AtomicReference();
    private final AtomicReference<Object> processHistogram = new AtomicReference();

    public void processMetricsRequest(ExportMetricsServiceRequest requests) {
        try (HistogramMetrics.Timer unused = this.getProcessHistogram().createTimer();){
            requests.getResourceMetricsList().forEach(request -> {
                if (log.isDebugEnabled()) {
                    log.debug("Resource attributes: {}", (Object)request.getResource().getAttributesList());
                }
                Map<String, String> nodeLabels = request.getResource().getAttributesList().stream().collect(Collectors.toMap(it -> LABEL_MAPPINGS.getOrDefault(it.getKey(), it.getKey()).replaceAll("\\.", "_"), it -> OpenTelemetryMetricRequestProcessor.anyValueToString(it.getValue()), (v1, v2) -> v1));
                ImmutableMap sampleFamilies = PrometheusMetricConverter.convertPromMetricToSampleFamily(request.getScopeMetricsList().stream().flatMap(scopeMetrics -> scopeMetrics.getMetricsList().stream().flatMap(metric -> this.adaptMetrics(nodeLabels, (io.opentelemetry.proto.metrics.v1.Metric)metric)).map(Function1.liftTry(Function.identity())).flatMap(tryIt -> MetricConvert.log((Try)tryIt, (String)"Convert OTEL metric to prometheus metric"))));
                this.converters.forEach(convert -> convert.toMeter(sampleFamilies));
            });
        }
    }

    public void start() throws ModuleStartException {
        List rules;
        List enabledRules = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)this.config.getEnabledOtelMetricsRules());
        try {
            rules = Rules.loadRules((String)"otel-rules", (List)enabledRules);
        }
        catch (IOException e) {
            throw new ModuleStartException("Failed to load otel rules.", (Throwable)e);
        }
        if (rules.isEmpty()) {
            return;
        }
        MeterSystem meterSystem = (MeterSystem)this.manager.find("core").provider().getService(MeterSystem.class);
        this.converters = rules.stream().map(r -> new MetricConvert((MetricRuleConfig)r, meterSystem)).collect(Collectors.toList());
    }

    private static Map<String, String> buildLabels(List<KeyValue> kvs) {
        return kvs.stream().collect(Collectors.toMap(KeyValue::getKey, it -> OpenTelemetryMetricRequestProcessor.anyValueToString(it.getValue())));
    }

    private static Map<String, String> mergeLabels(Map<String, String> nodeLabels, Map<String, String> pointLabels) {
        HashMap<String, String> result = new HashMap<String, String>(nodeLabels);
        result.putAll(pointLabels);
        return result;
    }

    private static Map<Double, Long> buildBuckets(List<Long> bucketCounts, List<Double> explicitBounds) {
        HashMap<Double, Long> result = new HashMap<Double, Long>();
        for (int i = 0; i < explicitBounds.size(); ++i) {
            result.put(explicitBounds.get(i), bucketCounts.get(i));
        }
        result.put(Double.POSITIVE_INFINITY, bucketCounts.get(explicitBounds.size()));
        return result;
    }

    private static Map<Double, Long> buildBucketsFromExponentialHistogram(int positiveOffset, List<Long> positiveBucketCounts, int negativeOffset, List<Long> negativeBucketCounts, int scale) {
        double upperBound;
        int i;
        HashMap<Double, Long> result = new HashMap<Double, Long>();
        double base = Math.pow(2.0, Math.pow(2.0, -scale));
        if (base == Double.POSITIVE_INFINITY) {
            log.warn("Receive and reject out-of-range ExponentialHistogram data");
            return result;
        }
        for (i = 0; i < negativeBucketCounts.size(); ++i) {
            upperBound = -Math.pow(base, negativeOffset + i);
            if (upperBound == Double.NEGATIVE_INFINITY) {
                log.warn("Receive and reject out-of-range ExponentialHistogram data");
                return new HashMap<Double, Long>();
            }
            result.put(upperBound, negativeBucketCounts.get(i));
        }
        for (i = 0; i < positiveBucketCounts.size() - 1; ++i) {
            upperBound = Math.pow(base, positiveOffset + i + 1);
            if (upperBound == Double.POSITIVE_INFINITY) {
                log.warn("Receive and reject out-of-range ExponentialHistogram data");
                return new HashMap<Double, Long>();
            }
            result.put(upperBound, positiveBucketCounts.get(i));
        }
        result.put(Double.POSITIVE_INFINITY, positiveBucketCounts.get(positiveBucketCounts.size() - 1));
        return result;
    }

    private Stream<? extends Metric> adaptMetrics(Map<String, String> nodeLabels, io.opentelemetry.proto.metrics.v1.Metric metric) {
        if (metric.hasGauge()) {
            return metric.getGauge().getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Gauge(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasSum()) {
            Sum sum = metric.getSum();
            if (sum.getAggregationTemporality() == AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED) {
                return Stream.empty();
            }
            if (sum.getAggregationTemporality() == AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA) {
                return sum.getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Gauge(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
            }
            if (sum.getIsMonotonic()) {
                return sum.getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Counter(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
            }
            return sum.getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Gauge(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasHistogram()) {
            return metric.getHistogram().getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Histogram(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.getCount(), point.getSum(), OpenTelemetryMetricRequestProcessor.buildBuckets(point.getBucketCountsList(), point.getExplicitBoundsList()), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasExponentialHistogram()) {
            return metric.getExponentialHistogram().getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Histogram(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.getCount(), point.getSum(), OpenTelemetryMetricRequestProcessor.buildBucketsFromExponentialHistogram(point.getPositive().getOffset(), point.getPositive().getBucketCountsList(), point.getNegative().getOffset(), point.getNegative().getBucketCountsList(), point.getScale()), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasSummary()) {
            return metric.getSummary().getDataPointsList().stream().filter(point -> (point.getFlags() & 1) != 1).map(point -> new Summary(metric.getName(), OpenTelemetryMetricRequestProcessor.mergeLabels(nodeLabels, OpenTelemetryMetricRequestProcessor.buildLabels(point.getAttributesList())), point.getCount(), point.getSum(), point.getQuantileValuesList().stream().collect(Collectors.toMap(SummaryDataPoint.ValueAtQuantile::getQuantile, SummaryDataPoint.ValueAtQuantile::getValue)), point.getTimeUnixNano() / 1000000L));
        }
        throw new UnsupportedOperationException("Unsupported type");
    }

    public static String anyValueToString(AnyValue value) {
        if (value.hasBoolValue()) {
            return Boolean.toString(value.getBoolValue());
        }
        if (value.hasIntValue()) {
            return Long.toString(value.getIntValue());
        }
        if (value.hasDoubleValue()) {
            return Double.toString(value.getDoubleValue());
        }
        return value.getStringValue();
    }

    @Generated
    public OpenTelemetryMetricRequestProcessor(ModuleManager manager, OtelMetricReceiverConfig config) {
        this.manager = manager;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public MetricsCreator getMetricsCreator() {
        Object value = this.metricsCreator.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.metricsCreator;
            synchronized (atomicReference) {
                value = this.metricsCreator.get();
                if (value == null) {
                    MetricsCreator actualValue = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
                    value = actualValue == null ? this.metricsCreator : actualValue;
                    this.metricsCreator.set(value);
                }
            }
        }
        return (MetricsCreator)(value == this.metricsCreator ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public HistogramMetrics getProcessHistogram() {
        Object value = this.processHistogram.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.processHistogram;
            synchronized (atomicReference) {
                value = this.processHistogram.get();
                if (value == null) {
                    HistogramMetrics actualValue = this.getMetricsCreator().createHistogramMetric("otel_metrics_latency", "The latency to process the metrics request", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 15.0, 30.0, 60.0, 120.0});
                    value = actualValue == null ? this.processHistogram : actualValue;
                    this.processHistogram.set(value);
                }
            }
        }
        return (HistogramMetrics)(value == this.processHistogram ? null : value);
    }
}

