/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.expr.rt;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.mqe.rt.MQEVisitorBase;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmMQEVerifyVisitor
extends MQEVisitorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmMQEVerifyVisitor.class);
    private final Set<String> includeMetrics = new HashSet<String>();
    private int maxTrendRange = 0;

    public AlarmMQEVerifyVisitor(ModuleManager moduleManager) {
        super(moduleManager, Step.MINUTE);
    }

    public ExpressionResult visitMetric(MQEParser.MetricContext ctx) {
        ExpressionResult result = new ExpressionResult();
        String metricName = ctx.metricName().getText();
        Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
        if (valueColumn.isEmpty()) {
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("Metric: [" + metricName + "] does not exist.");
            return result;
        }
        this.includeMetrics.add(metricName);
        if (ctx.parent instanceof MQEParser.TopNOPContext) {
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("Unsupported operation: [top_n] in alarm expression.");
            return result;
        }
        Column.ValueDataType dataType = ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType();
        MQEValues mockMqeValues = new MQEValues();
        MQEValue mqeValue = new MQEValue();
        mqeValue.setEmptyValue(true);
        mockMqeValues.getValues().add(mqeValue);
        result.getResults().add(mockMqeValues);
        result.setType(ExpressionResultType.TIME_SERIES_VALUES);
        if (dataType == Column.ValueDataType.COMMON_VALUE) {
            return result;
        }
        if (dataType == Column.ValueDataType.LABELED_VALUE) {
            result.setLabeledResult(true);
            return result;
        }
        result.setType(ExpressionResultType.UNKNOWN);
        result.setError("Metric does not supported in alarm, metric: [" + metricName + "] is not a common or labeled metric.");
        return result;
    }

    public ExpressionResult visitTrendOP(MQEParser.TrendOPContext ctx) {
        int trendRange = Integer.parseInt(ctx.INTEGER().getText());
        if (trendRange < 1) {
            ExpressionResult result = new ExpressionResult();
            result.setType(ExpressionResultType.UNKNOWN);
            result.setError("The trend range must be greater than 0.");
            return result;
        }
        this.setMaxTrendRange(trendRange);
        return super.visitTrendOP(ctx);
    }

    private void setMaxTrendRange(int trendRange) {
        if (trendRange > this.maxTrendRange) {
            this.maxTrendRange = trendRange;
        }
    }

    @Generated
    public Set<String> getIncludeMetrics() {
        return this.includeMetrics;
    }

    @Generated
    public int getMaxTrendRange() {
        return this.maxTrendRange;
    }
}

