/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.configuration.discovery.handler.grpc;

import com.google.common.collect.Lists;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.ConfigurationDiscoveryServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.v3.ConfigurationSyncRequest;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.network.trace.component.command.ConfigurationDiscoveryCommand;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.AgentConfigurations;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.AgentConfigurationsWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDiscoveryServiceHandler
extends ConfigurationDiscoveryServiceGrpc.ConfigurationDiscoveryServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationDiscoveryServiceHandler.class);
    private final AgentConfigurationsWatcher agentConfigurationsWatcher;
    private boolean disableMessageDigest = false;

    public ConfigurationDiscoveryServiceHandler(AgentConfigurationsWatcher agentConfigurationsWatcher, boolean disableMessageDigest) {
        this.agentConfigurationsWatcher = agentConfigurationsWatcher;
        this.disableMessageDigest = disableMessageDigest;
    }

    public void fetchConfigurations(ConfigurationSyncRequest request, StreamObserver<Commands> responseObserver) {
        Commands.Builder commandsBuilder = Commands.newBuilder();
        AgentConfigurations agentConfigurations = this.agentConfigurationsWatcher.getAgentConfigurations(request.getService());
        if (null != agentConfigurations && (this.disableMessageDigest || !Objects.equals(agentConfigurations.getUuid(), request.getUuid()))) {
            ConfigurationDiscoveryCommand configurationDiscoveryCommand = this.newAgentDynamicConfigCommand(agentConfigurations);
            commandsBuilder.addCommands(configurationDiscoveryCommand.serialize().build());
        }
        responseObserver.onNext((Object)commandsBuilder.build());
        responseObserver.onCompleted();
    }

    public ConfigurationDiscoveryCommand newAgentDynamicConfigCommand(AgentConfigurations agentConfigurations) {
        ArrayList configurationList = Lists.newArrayList();
        agentConfigurations.getConfiguration().forEach((k, v) -> {
            KeyStringValuePair.Builder builder = KeyStringValuePair.newBuilder().setKey(k).setValue(v);
            configurationList.add(builder.build());
        });
        return new ConfigurationDiscoveryCommand(UUID.randomUUID().toString(), agentConfigurations.getUuid(), (List)configurationList);
    }
}

