/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.prometheus;

import io.prometheus.client.Histogram;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.apache.skywalking.oap.server.telemetry.prometheus.BaseMetrics;

public class PrometheusHistogramMetrics
extends HistogramMetrics {
    private InnerMetricObject inner;
    private final double[] buckets;

    public PrometheusHistogramMetrics(String name, String tips, MetricsTag.Keys labels, MetricsTag.Values values, double ... buckets) {
        this.inner = new InnerMetricObject(name, tips, labels, values);
        this.buckets = buckets;
    }

    public void observe(double value) {
        Histogram.Child metrics = (Histogram.Child)this.inner.getMetric();
        if (metrics != null) {
            metrics.observe(value);
        }
    }

    class InnerMetricObject
    extends BaseMetrics<Histogram, Histogram.Child> {
        public InnerMetricObject(String name, String tips, MetricsTag.Keys labels, MetricsTag.Values values) {
            super(name, tips, labels, values);
        }

        @Override
        protected Histogram create(String[] labelNames) {
            Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)Histogram.build().name(this.name)).help(this.tips);
            if (builder != null && PrometheusHistogramMetrics.this.buckets.length > 0) {
                builder = builder.buckets(PrometheusHistogramMetrics.this.buckets);
            }
            return (Histogram)((Histogram.Builder)builder.labelNames(labelNames)).register();
        }
    }
}

