/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixProtocolType;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixRequest;

public class ZabbixRequestJsonDeserializer
implements JsonDeserializer<ZabbixRequest> {
    public ZabbixRequest deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String requestTypeString = json.getAsJsonObject().get("request").getAsString();
        ZabbixProtocolType requestType = ZabbixProtocolType.parse(requestTypeString);
        if (requestType == null) {
            throw new JsonParseException("Current request type is not support:" + requestTypeString);
        }
        ZabbixRequest data = new ZabbixRequest();
        data.setType(requestType);
        if (requestType == ZabbixProtocolType.AGENT_DATA) {
            data.setAgentDataList((List)context.deserialize((JsonElement)json.getAsJsonObject().getAsJsonArray("data"), new TypeToken<List<ZabbixRequest.AgentData>>(){}.getType()));
        } else if (requestType == ZabbixProtocolType.ACTIVE_CHECKS) {
            ZabbixRequest.ActiveChecks checksData = new ZabbixRequest.ActiveChecks();
            checksData.setHostName(json.getAsJsonObject().get("host").getAsString());
            data.setActiveChecks(checksData);
        }
        return data;
    }
}

