/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class DataLoaderDispatcherInstrumentation
extends SimplePerformantInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(DataLoaderDispatcherInstrumentation.class);
    private final DataLoaderDispatcherInstrumentationOptions options;

    public DataLoaderDispatcherInstrumentation() {
        this(DataLoaderDispatcherInstrumentationOptions.newOptions());
    }

    public DataLoaderDispatcherInstrumentation(DataLoaderDispatcherInstrumentationOptions options) {
        this.options = options;
    }

    @Override
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new DataLoaderDispatcherInstrumentationState(log, parameters.getExecutionInput().getDataLoaderRegistry());
    }

    @Override
    @NotNull
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState rawState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState(rawState);
        if (state.isAggressivelyBatching()) {
            return dataFetcher;
        }
        return environment -> {
            Object obj = dataFetcher.get(environment);
            this.immediatelyDispatch(state);
            return obj;
        };
    }

    private void immediatelyDispatch(DataLoaderDispatcherInstrumentationState state) {
        state.getApproach().dispatch();
    }

    @Override
    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState rawState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState(rawState);
        DataLoaderRegistry finalRegistry = parameters.getExecutionContext().getDataLoaderRegistry();
        state.setDataLoaderRegistry(finalRegistry);
        if (!this.isDataLoaderCompatibleExecution(parameters.getExecutionContext())) {
            state.setAggressivelyBatching(false);
        }
        return SimpleInstrumentationContext.noOp();
    }

    private boolean isDataLoaderCompatibleExecution(ExecutionContext executionContext) {
        OperationDefinition.Operation operation = executionContext.getOperationDefinition().getOperation();
        ExecutionStrategy strategy = executionContext.getStrategy(operation);
        return strategy instanceof AsyncExecutionStrategy;
    }

    @Override
    @Nullable
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState rawState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState(rawState);
        if (state.hasNoDataLoaders()) {
            return ExecutionStrategyInstrumentationContext.NOOP;
        }
        return state.getApproach().beginExecutionStrategy(parameters, state.getState());
    }

    @Override
    @Nullable
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState rawState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState(rawState);
        if (state.hasNoDataLoaders()) {
            return SimpleInstrumentationContext.noOp();
        }
        return state.getApproach().beginFieldFetch(parameters, state.getState());
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState rawState) {
        if (!this.options.isIncludeStatistics()) {
            return CompletableFuture.completedFuture(executionResult);
        }
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState(rawState);
        Map<Object, Object> currentExt = executionResult.getExtensions();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>(currentExt == null ? ImmutableKit.emptyMap() : currentExt);
        Map<Object, Object> dataLoaderStats = this.buildStatsMap(state);
        statsMap.put("dataloader", dataLoaderStats);
        if (log.isDebugEnabled()) {
            log.debug("Data loader stats : {}", dataLoaderStats);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), executionResult.getErrors(), statsMap));
    }

    private Map<Object, Object> buildStatsMap(DataLoaderDispatcherInstrumentationState state) {
        DataLoaderRegistry dataLoaderRegistry = state.getDataLoaderRegistry();
        Statistics allStats = dataLoaderRegistry.getStatistics();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.put("overall-statistics", allStats.toMap());
        LinkedHashMap<String, Map> individualStatsMap = new LinkedHashMap<String, Map>();
        for (String dlKey : dataLoaderRegistry.getKeys()) {
            DataLoader dl = dataLoaderRegistry.getDataLoader(dlKey);
            Statistics statistics = dl.getStatistics();
            individualStatsMap.put(dlKey, statistics.toMap());
        }
        statsMap.put("individual-statistics", individualStatsMap);
        return statsMap;
    }
}

