/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import com.google.protobuf.InvalidProtocolBufferException;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.AbstractKafkaHandler;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSegmentHandler
extends AbstractKafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceSegmentHandler.class);
    private final ISegmentParserService segmentParserService;
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;

    public TraceSegmentHandler(ModuleManager moduleManager, KafkaFetcherConfig config) {
        super(moduleManager, config);
        this.segmentParserService = (ISegmentParserService)moduleManager.find("agent-analyzer").provider().getService(ISegmentParserService.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("trace_in_latency", "The process latency of trace data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("trace_analysis_error_count", "The error number of trace analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
    }

    @Override
    public void handle(ConsumerRecord<String, Bytes> record) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            SegmentObject segment = SegmentObject.parseFrom((byte[])((Bytes)record.value()).get());
            if (log.isDebugEnabled()) {
                log.debug("Fetched a tracing segment[{}] from service instance[{}].", (Object)segment.getTraceSegmentId(), (Object)segment.getServiceInstance());
            }
            this.segmentParserService.send(segment);
        }
        catch (InvalidProtocolBufferException e) {
            this.errorCounter.inc();
            log.error("handle record failed", (Throwable)e);
        }
    }

    @Override
    protected String getPlainTopic() {
        return this.config.getTopicNameOfTracingSegments();
    }
}

