/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentReference;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.generator.Generator;
import org.apache.skywalking.restapi.TagGenerator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public final class SpanGenerator
implements Generator<SpanGeneratorContext, SpanObject> {
    private Generator<Object, Long> endTime;
    private Generator<Object, Long> latency;
    private Generator<String, String> operationName;
    private Generator<Object, Long> componentId;
    private Generator<Object, Boolean> error;
    private Generator<Object, List<TagGenerator>> tags;

    @Override
    public SpanObject next(SpanGeneratorContext ctx) {
        long now = this.endTime == null ? ctx.now : this.endTime.next(null);
        SpanObject.Builder sob = SpanObject.newBuilder().setSpanId(ctx.index).setParentSpanId(ctx.index - 1).setStartTime(now - this.latency.next(null)).setEndTime(now).setComponentId(this.getComponentId().next(null).intValue()).setIsError(this.getError().next(null).booleanValue()).addAllTags((Iterable)this.getTags().next(null).stream().map(tg -> tg.next((Object)null)).map(it -> KeyStringValuePair.newBuilder().setKey(it.getKey()).setValue(it.getValue()).build()).collect(Collectors.toList()));
        if (ctx.index == 0) {
            sob.setSpanLayer(SpanLayer.Http).setSpanType(SpanType.Entry);
            if (ctx.ref != null) {
                sob.addRefs(ctx.ref);
            }
        } else if (ctx.length > 1 && ctx.index == ctx.length - 1) {
            sob.setSpanType(SpanType.Exit);
            if (ctx.peer != null) {
                sob.setPeer(ctx.peer).setSpanLayer(SpanLayer.Http);
            } else {
                sob.setPeer("peer-database").setSpanLayer(SpanLayer.Database);
            }
        } else {
            sob.setSpanType(SpanType.Local);
        }
        return sob.build();
    }

    @Override
    public void reset() {
        this.operationName.reset();
        this.componentId.reset();
        this.error.reset();
        this.tags.reset();
    }

    @Generated
    public Generator<Object, Long> getEndTime() {
        return this.endTime;
    }

    @Generated
    public Generator<Object, Long> getLatency() {
        return this.latency;
    }

    @Generated
    public Generator<String, String> getOperationName() {
        return this.operationName;
    }

    @Generated
    public Generator<Object, Long> getComponentId() {
        return this.componentId;
    }

    @Generated
    public Generator<Object, Boolean> getError() {
        return this.error;
    }

    @Generated
    public Generator<Object, List<TagGenerator>> getTags() {
        return this.tags;
    }

    @Generated
    public void setEndTime(Generator<Object, Long> endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLatency(Generator<Object, Long> latency) {
        this.latency = latency;
    }

    @Generated
    public void setOperationName(Generator<String, String> operationName) {
        this.operationName = operationName;
    }

    @Generated
    public void setComponentId(Generator<Object, Long> componentId) {
        this.componentId = componentId;
    }

    @Generated
    public void setError(Generator<Object, Boolean> error) {
        this.error = error;
    }

    @Generated
    public void setTags(Generator<Object, List<TagGenerator>> tags) {
        this.tags = tags;
    }

    public static class SpanGeneratorContext {
        final int index;
        final int length;
        final SegmentReference ref;
        final String peer;
        final long now;

        @Generated
        public SpanGeneratorContext(int index, int length, SegmentReference ref, String peer, long now) {
            this.index = index;
            this.length = length;
            this.ref = ref;
            this.peer = peer;
            this.now = now;
        }
    }
}

