/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.grpc.StackTraceElementProto;
import com.linecorp.armeria.common.grpc.StatusCauseException;
import com.linecorp.armeria.common.grpc.ThrowableProto;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.StatusMessageEscaper;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.TransportStatusListener;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcStatus {
    private static final Logger logger = LoggerFactory.getLogger(GrpcStatus.class);

    public static HttpStatus grpcStatusToHttpStatus(ServiceRequestContext ctx, Status grpcStatus) {
        if (grpcStatus.getCode() == Status.Code.CANCELLED) {
            Throwable responseCause;
            RequestLog log = ctx.log().getIfAvailable(new RequestLogProperty[]{RequestLogProperty.RESPONSE_CAUSE});
            if (log != null && (responseCause = log.responseCause()) != null && (responseCause instanceof RequestTimeoutException || responseCause.getCause() instanceof RequestTimeoutException)) {
                return HttpStatus.SERVICE_UNAVAILABLE;
            }
            if ("Completed without a response".equals(grpcStatus.getDescription())) {
                return HttpStatus.INTERNAL_SERVER_ERROR;
            }
        }
        return GrpcStatus.grpcCodeToHttpStatus(grpcStatus.getCode());
    }

    public static HttpStatus grpcCodeToHttpStatus(Status.Code grpcStatusCode) {
        switch (grpcStatusCode) {
            case OK: {
                return HttpStatus.OK;
            }
            case CANCELLED: {
                return HttpStatus.CLIENT_CLOSED_REQUEST;
            }
            case UNKNOWN: 
            case INTERNAL: 
            case DATA_LOSS: {
                return HttpStatus.INTERNAL_SERVER_ERROR;
            }
            case INVALID_ARGUMENT: 
            case FAILED_PRECONDITION: 
            case OUT_OF_RANGE: {
                return HttpStatus.BAD_REQUEST;
            }
            case DEADLINE_EXCEEDED: {
                return HttpStatus.GATEWAY_TIMEOUT;
            }
            case NOT_FOUND: {
                return HttpStatus.NOT_FOUND;
            }
            case ALREADY_EXISTS: 
            case ABORTED: {
                return HttpStatus.CONFLICT;
            }
            case PERMISSION_DENIED: {
                return HttpStatus.FORBIDDEN;
            }
            case UNAUTHENTICATED: {
                return HttpStatus.UNAUTHORIZED;
            }
            case RESOURCE_EXHAUSTED: {
                return HttpStatus.TOO_MANY_REQUESTS;
            }
            case UNIMPLEMENTED: {
                return HttpStatus.NOT_IMPLEMENTED;
            }
            case UNAVAILABLE: {
                return HttpStatus.SERVICE_UNAVAILABLE;
            }
        }
        return HttpStatus.UNKNOWN;
    }

    public static Status httpStatusToGrpcStatus(int httpStatusCode) {
        return GrpcStatus.httpStatusToGrpcCode(httpStatusCode).toStatus().withDescription("HTTP status code " + httpStatusCode);
    }

    private static Status.Code httpStatusToGrpcCode(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Status.Code.INTERNAL;
        }
        switch (httpStatusCode) {
            case 400: 
            case 431: {
                return Status.Code.INTERNAL;
            }
            case 401: {
                return Status.Code.UNAUTHENTICATED;
            }
            case 403: {
                return Status.Code.PERMISSION_DENIED;
            }
            case 404: {
                return Status.Code.UNIMPLEMENTED;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                return Status.Code.UNAVAILABLE;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static ThrowableProto serializeThrowable(Throwable t) {
        ThrowableProto.Builder builder = ThrowableProto.newBuilder();
        if (t instanceof StatusCauseException) {
            StatusCauseException statusCause = (StatusCauseException)t;
            builder.setOriginalClassName(statusCause.getOriginalClassName());
            builder.setOriginalMessage(statusCause.getOriginalMessage());
        } else {
            builder.setOriginalClassName(t.getClass().getCanonicalName());
            builder.setOriginalMessage(Strings.nullToEmpty((String)t.getMessage()));
        }
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        int maxStackTraceElements = Math.min(10, stackTraceElements.length);
        for (int i = 0; i < maxStackTraceElements; ++i) {
            builder.addStackTrace(GrpcStatus.serializeStackTraceElement(stackTraceElements[i]));
        }
        if (t.getCause() != null) {
            builder.setCause(GrpcStatus.serializeThrowable(t.getCause()));
        }
        return builder.build();
    }

    public static void reportStatusLater(HttpHeaders headers, StreamMessage<DeframedMessage> deframedStreamMessage, TransportStatusListener transportStatusListener) {
        deframedStreamMessage.whenComplete().handle((unused1, unused2) -> {
            GrpcStatus.reportStatus(headers, transportStatusListener);
            return null;
        });
    }

    public static void reportStatus(HttpHeaders headers, TransportStatusListener transportStatusListener) {
        String grpcThrowable;
        String grpcStatus = headers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        Status status = Status.fromCodeValue((int)Integer.valueOf(grpcStatus));
        String grpcMessage = headers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
        if (grpcMessage != null) {
            status = status.withDescription(StatusMessageEscaper.unescape((String)grpcMessage));
        }
        if ((grpcThrowable = headers.get((CharSequence)GrpcHeaderNames.ARMERIA_GRPC_THROWABLEPROTO_BIN)) != null) {
            status = GrpcStatus.addCause(status, grpcThrowable);
        }
        Metadata metadata = MetadataUtil.copyFromHeaders(headers);
        transportStatusListener.transportReportStatus(status, metadata);
    }

    private static Status addCause(Status status, String serializedThrowableProto) {
        ThrowableProto grpcThrowableProto;
        byte[] decoded;
        try {
            decoded = Base64.getDecoder().decode(serializedThrowableProto);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid Base64 in status cause proto, ignoring.", (Throwable)e);
            return status;
        }
        try {
            grpcThrowableProto = ThrowableProto.parseFrom(decoded);
        }
        catch (InvalidProtocolBufferException e) {
            logger.warn("Invalid serialized status cause proto, ignoring.", (Throwable)e);
            return status;
        }
        return status.withCause((Throwable)new StatusCauseException(grpcThrowableProto));
    }

    private static StackTraceElementProto serializeStackTraceElement(StackTraceElement element) {
        StackTraceElementProto.Builder builder = StackTraceElementProto.newBuilder().setClassName(element.getClassName()).setMethodName(element.getMethodName()).setLineNumber(element.getLineNumber());
        if (element.getFileName() != null) {
            builder.setFileName(element.getFileName());
        }
        return builder.build();
    }

    private GrpcStatus() {
    }
}

