/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.YamlConfigLoaderUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BanyanDBConfigLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBConfigLoader.class);
    private final ModuleProvider moduleProvider;
    private final Yaml yaml;

    public BanyanDBConfigLoader(ModuleProvider moduleProvider) {
        this.moduleProvider = moduleProvider;
        this.yaml = new Yaml();
    }

    public BanyanDBStorageConfig loadConfig() throws ModuleStartException {
        BanyanDBStorageConfig config = new BanyanDBStorageConfig();
        Reader applicationReader = null;
        try {
            applicationReader = ResourceUtils.read((String)"bydb.yml");
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Cannot find the BanyanDB configuration file [bydb.yml].", (Throwable)e);
        }
        Map configMap = (Map)this.yaml.loadAs(applicationReader, Map.class);
        if (configMap == null) {
            return config;
        }
        HashMap configProperties = new HashMap();
        configMap.forEach((part, c) -> {
            Properties properties = new Properties();
            if (c != null) {
                for (Map.Entry entry : c.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    Object propertyValue = entry.getValue();
                    if (propertyValue instanceof Map) {
                        Properties subProperties = new Properties();
                        for (Map.Entry e : ((Map)propertyValue).entrySet()) {
                            String key = (String)e.getKey();
                            Object value = e.getValue();
                            subProperties.put(key, value);
                            YamlConfigLoaderUtils.replacePropertyAndLog((String)key, value, (Properties)subProperties, (Object)this.moduleProvider.name(), (Yaml)this.yaml);
                        }
                        properties.put(propertyName, subProperties);
                        continue;
                    }
                    properties.put(propertyName, propertyValue);
                    YamlConfigLoaderUtils.replacePropertyAndLog((String)propertyName, propertyValue, (Properties)properties, (Object)this.moduleProvider.name(), (Yaml)this.yaml);
                }
                configProperties.put(part, properties);
            }
        });
        try {
            YamlConfigLoaderUtils.copyProperties((Object)config.getGlobal(), (Properties)((Properties)configProperties.get("global")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            Properties groups = (Properties)configProperties.get("groups");
            YamlConfigLoaderUtils.copyProperties((Object)config.getRecordsNormal(), (Properties)((Properties)groups.get("recordsNormal")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)config.getRecordsSuper(), (Properties)((Properties)groups.get("recordsSuper")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)config.getMetricsMin(), (Properties)((Properties)groups.get("metricsMin")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)config.getMetricsHour(), (Properties)((Properties)groups.get("metricsHour")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)config.getMetricsDay(), (Properties)((Properties)groups.get("metricsDay")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)config.getMetadata(), (Properties)((Properties)groups.get("metadata")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
            YamlConfigLoaderUtils.copyProperties((Object)config.getProperty(), (Properties)((Properties)groups.get("property")), (String)this.moduleProvider.getModule().name(), (String)this.moduleProvider.name());
        }
        catch (IllegalAccessException e) {
            throw new ModuleStartException("Failed to load BanyanDB configuration.", (Throwable)e);
        }
        return config;
    }
}

