/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.proxy;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyConfigSelector;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WrappingProxyConfigSelector
implements ProxyConfigSelector {
    private static final Logger logger = LoggerFactory.getLogger(WrappingProxyConfigSelector.class);
    private final ProxySelector proxySelector;

    private static URI toUri(SessionProtocol sessionProtocol, Endpoint endpoint) {
        try {
            return new URI(sessionProtocol.uriText(), endpoint.authority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static InetSocketAddress resolve(InetSocketAddress inetSocketAddress) {
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        return new InetSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }

    private static ProxyConfig toProxyConfig(@Nullable Proxy proxy) {
        if (proxy == null || proxy.address() == null) {
            return ProxyConfig.direct();
        }
        InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
        switch (proxy.type()) {
            case HTTP: {
                return ProxyConfig.connect(WrappingProxyConfigSelector.resolve(proxyAddress));
            }
            case SOCKS: {
                return ProxyConfig.socks5(WrappingProxyConfigSelector.resolve(proxyAddress));
            }
        }
        return ProxyConfig.direct();
    }

    static WrappingProxyConfigSelector of(ProxySelector proxySelector) {
        return new WrappingProxyConfigSelector(proxySelector);
    }

    private WrappingProxyConfigSelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    @Override
    public ProxyConfig select(SessionProtocol protocol, Endpoint endpoint) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpoint, "endpoint");
        List<Proxy> proxies = this.proxySelector.select(WrappingProxyConfigSelector.toUri(protocol, endpoint));
        if (proxies == null || proxies.isEmpty()) {
            return ProxyConfig.direct();
        }
        Proxy proxy = proxies.get(0);
        if (logger.isDebugEnabled() && proxies.size() > 1) {
            logger.debug("Using the first proxy <{}> of <{}>.", (Object)proxy, proxies);
        }
        return WrappingProxyConfigSelector.toProxyConfig(proxy);
    }

    @Override
    public void connectFailed(SessionProtocol protocol, Endpoint endpoint, SocketAddress socketAddress, Throwable throwable) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpoint, "endpoint");
        this.proxySelector.connectFailed(endpoint.toUri(protocol), Objects.requireNonNull(socketAddress, "socketAddress"), new IOException(throwable));
    }
}

