/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareRunnable;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.SafeCloseable;
import java.util.Objects;

final class DefaultContextAwareRunnable
implements ContextAwareRunnable {
    private final RequestContext context;
    private final Runnable runnable;

    DefaultContextAwareRunnable(RequestContext context, Runnable runnable) {
        this.context = Objects.requireNonNull(context, "context");
        this.runnable = Objects.requireNonNull(runnable, "runnable");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Runnable withoutContext() {
        return this.runnable;
    }

    @Override
    public void run() {
        try (SafeCloseable ignored = this.context.push();){
            this.runnable.run();
        }
    }
}

