/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.loadbalancer;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.loadbalancer.LoadBalancer;
import com.linecorp.armeria.common.loadbalancer.SimpleLoadBalancer;
import com.linecorp.armeria.common.loadbalancer.UpdatableLoadBalancer;
import com.linecorp.armeria.common.loadbalancer.WeightTransition;
import com.linecorp.armeria.common.loadbalancer.Weighted;
import com.linecorp.armeria.common.util.Ticker;
import com.linecorp.armeria.internal.common.loadbalancer.WeightedObject;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2LongOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.math.IntMath;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RampingUpLoadBalancer<T>
implements UpdatableLoadBalancer<T> {
    private static final Logger logger = LoggerFactory.getLogger(RampingUpLoadBalancer.class);
    private static final SimpleLoadBalancer<?> EMPTY_RANDOM_LOAD_BALANCER = LoadBalancer.ofWeightedRandom(ImmutableList.of(), x -> 0);
    private final long rampingUpIntervalNanos;
    private final int totalSteps;
    private final long rampingUpTaskWindowNanos;
    private final Ticker ticker;
    private final WeightTransition<T> weightTransition;
    @Nullable
    private final ToIntFunction<T> weightFunction;
    private final Function<T, Long> timestampFunction;
    private final EventExecutor executor;
    private final ReentrantShortLock lock = new ReentrantShortLock(true);
    private volatile SimpleLoadBalancer<Weighted> weightedRandomLoadBalancer = EMPTY_RANDOM_LOAD_BALANCER;
    private final List<Weighted> candidatesFinishedRampingUp = new ArrayList<Weighted>();
    final Map<Long, CandidatesRampingUpEntry<T>> rampingUpWindowsMap = new HashMap<Long, CandidatesRampingUpEntry<T>>();
    private Object2LongOpenHashMap<T> candidateCreatedTimestamps = new Object2LongOpenHashMap();

    RampingUpLoadBalancer(Iterable<T> candidates, @Nullable ToIntFunction<T> weightFunction, long rampingUpIntervalMillis, int totalSteps, long rampingUpTaskWindowMillis, WeightTransition<T> weightTransition, Function<T, Long> timestampFunction, Ticker ticker, EventExecutor executor) {
        this.rampingUpIntervalNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpIntervalMillis);
        this.totalSteps = totalSteps;
        this.rampingUpTaskWindowNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpTaskWindowMillis);
        this.ticker = ticker;
        this.weightTransition = weightTransition;
        this.weightFunction = weightFunction;
        this.timestampFunction = timestampFunction;
        this.executor = executor;
        this.updateCandidates(candidates);
    }

    @Override
    @Nullable
    public T pick() {
        SimpleLoadBalancer<Weighted> loadBalancer = this.weightedRandomLoadBalancer;
        Weighted weighted = loadBalancer.pick();
        if (weighted == null) {
            return null;
        }
        if (weighted instanceof WeightedObject) {
            return ((WeightedObject)weighted).get();
        }
        return (T)weighted;
    }

    @Override
    public void updateCandidates(Iterable<? extends T> candidates) {
        this.lock.lock();
        try {
            this.updateCandidates0(ImmutableList.copyOf(candidates));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateCandidates0(List<T> newCandidates) {
        for (CandidatesRampingUpEntry<T> entry : this.rampingUpWindowsMap.values()) {
            entry.candidateAndSteps().clear();
        }
        this.candidatesFinishedRampingUp.clear();
        Object2LongOpenHashMap<T> newCreatedTimestamps = new Object2LongOpenHashMap<T>();
        for (T candidate : newCandidates) {
            long createTimestamp = this.computeCreateTimestamp(candidate);
            newCreatedTimestamps.put(candidate, createTimestamp);
            int step = RampingUpLoadBalancer.numStep(this.rampingUpIntervalNanos, this.ticker, createTimestamp);
            if (step >= this.totalSteps) {
                this.candidatesFinishedRampingUp.add(RampingUpLoadBalancer.toWeighted(candidate, this.weightFunction));
                continue;
            }
            long window = this.windowIndex(createTimestamp);
            if (!this.rampingUpWindowsMap.containsKey(window)) {
                long initialDelayNanos = this.initialDelayNanos(window);
                io.netty.util.concurrent.ScheduledFuture scheduledFuture = this.executor.scheduleAtFixedRate(() -> this.updateWeightAndStep(window), initialDelayNanos, this.rampingUpIntervalNanos, TimeUnit.NANOSECONDS);
                CandidatesRampingUpEntry entry = new CandidatesRampingUpEntry(new HashSet(), (ScheduledFuture<?>)scheduledFuture);
                this.rampingUpWindowsMap.put(window, entry);
            }
            CandidatesRampingUpEntry<T> rampingUpEntry = this.rampingUpWindowsMap.get(window);
            CandidateAndStep<T> candidateAndStep = new CandidateAndStep<T>(candidate, this.weightFunction, this.weightTransition, step, this.totalSteps);
            rampingUpEntry.addCandidate(candidateAndStep);
        }
        this.candidateCreatedTimestamps = newCreatedTimestamps;
        this.buildLoadBalancer();
    }

    private long computeCreateTimestamp(T candidate) {
        Long timestamp;
        try {
            timestamp = this.timestampFunction.apply(candidate);
        }
        catch (Exception e) {
            logger.warn("Failed to compute the create timestamp for candidate: {}", candidate, (Object)e);
            return this.ticker.read();
        }
        if (timestamp != null) {
            return timestamp;
        }
        if (this.candidateCreatedTimestamps.containsKey(candidate)) {
            return this.candidateCreatedTimestamps.getLong(candidate);
        }
        return this.ticker.read();
    }

    private void buildLoadBalancer() {
        ImmutableList.Builder targetCandidatesBuilder = ImmutableList.builder();
        targetCandidatesBuilder.addAll(this.candidatesFinishedRampingUp);
        for (CandidatesRampingUpEntry<T> entry : this.rampingUpWindowsMap.values()) {
            for (CandidateAndStep<T> candidateAndStep : entry.candidateAndSteps()) {
                targetCandidatesBuilder.add(new WeightedObject<T>(candidateAndStep.candidate(), candidateAndStep.currentWeight()));
            }
        }
        ImmutableCollection candidates = targetCandidatesBuilder.build();
        if (this.rampingUpWindowsMap.isEmpty()) {
            logger.info("Finished ramping up. candidates: {}", (Object)candidates);
        } else {
            logger.debug("Ramping up. candidates: {}", (Object)candidates);
        }
        boolean found = false;
        for (Weighted candidate : candidates) {
            if (candidate.weight() <= 0) continue;
            found = true;
            break;
        }
        if (!found) {
            logger.warn("No valid candidate with weight > 0. candidates: {}", (Object)candidates);
        }
        this.weightedRandomLoadBalancer = LoadBalancer.ofWeightedRandom(candidates);
    }

    SimpleLoadBalancer<Weighted> weightedRandomLoadBalancer() {
        return this.weightedRandomLoadBalancer;
    }

    long windowIndex(long timestamp) {
        long window = timestamp % this.rampingUpIntervalNanos;
        if (this.rampingUpTaskWindowNanos > 0L) {
            window /= this.rampingUpTaskWindowNanos;
        }
        return window;
    }

    private long initialDelayNanos(long windowIndex) {
        long timestamp = this.ticker.read();
        long base = (timestamp / this.rampingUpIntervalNanos + 1L) * this.rampingUpIntervalNanos;
        long nextTimestamp = base + windowIndex * this.rampingUpTaskWindowNanos;
        return nextTimestamp - timestamp;
    }

    private void updateWeightAndStep(long window) {
        this.lock.lock();
        try {
            this.updateWeightAndStep0(window);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateWeightAndStep0(long window) {
        CandidatesRampingUpEntry<T> entry = this.rampingUpWindowsMap.get(window);
        assert (entry != null);
        Set<CandidateAndStep<T>> candidateAndSteps = entry.candidateAndSteps();
        this.updateWeightAndStep0(candidateAndSteps);
        if (candidateAndSteps.isEmpty()) {
            this.rampingUpWindowsMap.remove((Object)Long.valueOf((long)window)).scheduledFuture.cancel(true);
        }
        this.buildLoadBalancer();
    }

    private void updateWeightAndStep0(Set<CandidateAndStep<T>> candidateAndSteps) {
        Iterator<CandidateAndStep<T>> i = candidateAndSteps.iterator();
        while (i.hasNext()) {
            CandidateAndStep<T> candidateAndStep = i.next();
            int step = candidateAndStep.incrementAndGetStep();
            Weighted candidate = candidateAndStep.weighted();
            if (step < this.totalSteps) continue;
            this.candidatesFinishedRampingUp.add(candidate);
            i.remove();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.rampingUpWindowsMap.values().forEach(e -> e.scheduledFuture.cancel(true));
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("weightedRandomLoadBalancer", this.weightedRandomLoadBalancer).add("candidatesFinishedRampingUp", this.candidatesFinishedRampingUp).add("rampingUpWindowsMap", this.rampingUpWindowsMap).toString();
    }

    private static int numStep(long rampingUpIntervalNanos, Ticker ticker, long createTimestamp) {
        long timePassed = ticker.read() - createTimestamp;
        int step = Ints.saturatedCast(timePassed / rampingUpIntervalNanos);
        return IntMath.saturatedAdd(step, 1);
    }

    private static <T> Weighted toWeighted(T candidate, @Nullable ToIntFunction<T> weightFunction) {
        if (weightFunction == null) {
            return (Weighted)candidate;
        }
        return new WeightedObject<T>(candidate, weightFunction.applyAsInt(candidate));
    }

    static final class CandidatesRampingUpEntry<T> {
        private final Set<CandidateAndStep<T>> candidateAndSteps;
        final ScheduledFuture<?> scheduledFuture;

        CandidatesRampingUpEntry(Set<CandidateAndStep<T>> candidateAndSteps, ScheduledFuture<?> scheduledFuture) {
            this.candidateAndSteps = candidateAndSteps;
            this.scheduledFuture = scheduledFuture;
        }

        Set<CandidateAndStep<T>> candidateAndSteps() {
            return this.candidateAndSteps;
        }

        void addCandidate(CandidateAndStep<T> candidate) {
            this.candidateAndSteps.add(candidate);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("candidateAndSteps", this.candidateAndSteps).add("scheduledFuture", this.scheduledFuture).toString();
        }
    }

    static final class CandidateAndStep<T> {
        private final T candidate;
        private final Weighted weighted;
        private final WeightTransition<T> weightTransition;
        private int step;
        private final int totalSteps;
        private int currentWeight;

        CandidateAndStep(T candidate, @Nullable ToIntFunction<T> weightFunction, WeightTransition<T> weightTransition, int step, int totalSteps) {
            this.candidate = candidate;
            this.weighted = RampingUpLoadBalancer.toWeighted(candidate, weightFunction);
            this.weightTransition = weightTransition;
            this.step = step;
            this.totalSteps = totalSteps;
        }

        int incrementAndGetStep() {
            return ++this.step;
        }

        int currentWeight() {
            this.currentWeight = this.computeWeight();
            return this.currentWeight;
        }

        private int computeWeight() {
            int originalWeight = this.weighted.weight();
            int calculated = this.weightTransition.compute(this.candidate, originalWeight, this.step, this.totalSteps);
            return Ints.constrainToRange(calculated, 0, originalWeight);
        }

        int step() {
            return this.step;
        }

        Weighted weighted() {
            return this.weighted;
        }

        T candidate() {
            return this.candidate;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("candidate", this.candidate).add("currentWeight", this.currentWeight).add("weightTransition", this.weightTransition).add("step", this.step).add("totalSteps", this.totalSteps).toString();
        }
    }
}

