/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.CountingSampler;
import com.linecorp.armeria.common.util.RateLimitingSampler;
import com.linecorp.armeria.common.util.Samplers;

@FunctionalInterface
public interface Sampler<T> {
    public static <T> Sampler<T> random(float probability) {
        return CountingSampler.create(probability);
    }

    public static <T> Sampler<T> rateLimiting(int samplesPerSecond) {
        return RateLimitingSampler.create(samplesPerSecond);
    }

    public static <T> Sampler<T> always() {
        Sampler cast = Samplers.ALWAYS;
        return cast;
    }

    public static <T> Sampler<T> never() {
        Sampler cast = Samplers.NEVER;
        return cast;
    }

    public static <T> Sampler<T> of(String specification) {
        return Samplers.of(specification);
    }

    public boolean isSampled(T var1);
}

