/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

final class Samplers {
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final String IAE_MSG_TEMPLATE = "specification: %s (expected: always, never, random=<probability> or rate-limited=<samples_per_second>";
    static final Sampler ALWAYS = new Sampler(){

        public boolean isSampled(Object ignored) {
            return true;
        }

        public String toString() {
            return "always";
        }
    };
    static final Sampler NEVER = new Sampler(){

        public boolean isSampled(Object ignored) {
            return false;
        }

        public String toString() {
            return "never";
        }
    };

    static <T> Sampler<T> of(String specification) {
        Objects.requireNonNull(specification, "specification");
        switch (specification.trim()) {
            case "always": 
            case "true": {
                return Sampler.always();
            }
            case "never": 
            case "false": {
                return Sampler.never();
            }
        }
        List<String> components = KEY_VALUE_SPLITTER.splitToList(specification);
        Preconditions.checkArgument(components.size() == 2, IAE_MSG_TEMPLATE, (Object)specification);
        String key = components.get(0);
        String value = components.get(1);
        try {
            switch (key) {
                case "random": {
                    return Sampler.random(Float.parseFloat(value));
                }
                case "rate-limit": 
                case "rate-limiting": 
                case "rate-limited": {
                    return Sampler.rateLimiting(Integer.parseInt(value));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, IAE_MSG_TEMPLATE, specification), e);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, IAE_MSG_TEMPLATE, specification));
    }

    private Samplers() {
    }
}

