/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthorizationStatus;
import com.linecorp.armeria.server.auth.Authorizer;
import java.util.concurrent.CompletionStage;

final class AuthorizerUtil {
    static <T> CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(Authorizer<T> authorizer, ServiceRequestContext ctx, @Nullable T data) {
        try {
            CompletionStage<AuthorizationStatus> f = authorizer.authorizeAndSupplyHandlers(ctx, data);
            if (f == null) {
                throw new NullPointerException("An " + Authorizer.class.getSimpleName() + " returned null: " + authorizer);
            }
            return f;
        }
        catch (Throwable cause) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(cause);
        }
    }

    static NullPointerException newNullResultException(Authorizer<?> authorizer) {
        return new NullPointerException("A future returned by an " + Authorizer.class.getSimpleName() + " has been fulfilled with null: " + authorizer);
    }

    private AuthorizerUtil() {
    }
}

