/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.throttling;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.throttling.ThrottlingAcceptHandler;
import com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import com.linecorp.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;

abstract class AbstractThrottlingServiceBuilder<I extends Request, O extends Response> {
    private final ThrottlingStrategy<I> strategy;
    private ThrottlingAcceptHandler<I, O> acceptHandler;
    private ThrottlingRejectHandler<I, O> rejectHandler;

    AbstractThrottlingServiceBuilder(ThrottlingStrategy<I> strategy, ThrottlingRejectHandler<I, O> defaultRejectHandler) {
        this.strategy = Objects.requireNonNull(strategy, "strategy");
        this.acceptHandler = Service::serve;
        this.rejectHandler = Objects.requireNonNull(defaultRejectHandler, "defaultRejectHandler");
    }

    final ThrottlingStrategy<I> getStrategy() {
        return this.strategy;
    }

    final void setAcceptHandler(ThrottlingAcceptHandler<I, O> acceptHandler) {
        this.acceptHandler = Objects.requireNonNull(acceptHandler, "acceptHandler");
    }

    final ThrottlingAcceptHandler<I, O> getAcceptHandler() {
        return this.acceptHandler;
    }

    final void setRejectHandler(ThrottlingRejectHandler<I, O> rejectHandler) {
        this.rejectHandler = Objects.requireNonNull(rejectHandler, "rejectHandler");
    }

    final ThrottlingRejectHandler<I, O> getRejectHandler() {
        return this.rejectHandler;
    }
}

