/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.client;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplate;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplates;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateClient.class);
    private final CompletableFuture<ElasticSearchVersion> version;
    private final WebClient client;

    public boolean exists(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().exists(name)).aggregate().thenApply(response -> {
            HttpStatus status = response.status();
            if (status == HttpStatus.OK) {
                return true;
            }
            if (status == HttpStatus.NOT_FOUND) {
                return false;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to check whether template {} exists", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to check whether template {} exists {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public Optional<IndexTemplate> get(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().get(name)).aggregate().thenApply(response -> {
            HttpStatus status = response.status();
            if (status == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            if (status != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
            try (HttpData content = response.content();){
                Optional<IndexTemplate> optional;
                block16: {
                    InputStream is = content.toInputStream();
                    try {
                        IndexTemplates templates = v.codec().decode(is, IndexTemplates.class);
                        optional = templates.get(name);
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return optional;
            }
            catch (Exception e) {
                return (Optional)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get index template {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to get index template {}, {}", (Object)name, result);
            }
        });
        return (Optional)((CompletableFuture)future).get();
    }

    public boolean delete(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().delete(name)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to delete index template {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to delete index template {}, {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public boolean createOrUpdate(String name, Map<String, Object> settings, Mappings mappings, int order) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().createOrUpdate(name, settings, mappings, order)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to create / update index template {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to create / update index template {}, {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    @Generated
    public TemplateClient(CompletableFuture<ElasticSearchVersion> version, WebClient client) {
        this.version = version;
        this.client = client;
    }
}

