/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.profiling.ebpf.EBPFProfilingQueryService;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeAggregateType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskPrepare;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EBPFProcessProfilingQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private EBPFProfilingQueryService queryService;

    public EBPFProcessProfilingQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public EBPFProfilingQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (EBPFProfilingQueryService)this.moduleManager.find("core").provider().getService(EBPFProfilingQueryService.class);
        }
        return this.queryService;
    }

    public CompletableFuture<EBPFProfilingTaskPrepare> queryPrepareCreateEBPFProfilingTaskData(String serviceId) {
        if (StringUtil.isEmpty((String)serviceId)) {
            throw new IllegalArgumentException("please provide the service id");
        }
        return AsyncQueryUtils.queryAsync(() -> this.getQueryService().queryPrepareCreateEBPFProfilingTaskData(serviceId));
    }

    public CompletableFuture<List<EBPFProfilingTask>> queryEBPFProfilingTasks(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targets, EBPFProfilingTriggerType triggerType, Duration duration) {
        if (StringUtil.isEmpty((String)serviceId) && StringUtil.isEmpty((String)serviceInstanceId)) {
            throw new IllegalArgumentException("please provide the service id or instance id");
        }
        return AsyncQueryUtils.queryAsync(() -> this.getQueryService().queryEBPFProfilingTasks(serviceId, serviceInstanceId, targets, Objects.requireNonNullElse(triggerType, EBPFProfilingTriggerType.FIXED_TIME), duration));
    }

    public CompletableFuture<List<EBPFProfilingSchedule>> queryEBPFProfilingSchedules(String taskId) {
        return AsyncQueryUtils.queryAsync(() -> this.getQueryService().queryEBPFProfilingSchedules(taskId));
    }

    public CompletableFuture<EBPFProfilingAnalyzation> analysisEBPFProfilingResult(List<String> scheduleIdList, List<EBPFProfilingAnalyzeTimeRange> timeRanges, EBPFProfilingAnalyzeAggregateType aggregateType) {
        return AsyncQueryUtils.queryAsync(() -> this.getQueryService().getEBPFProfilingAnalyzation(scheduleIdList, timeRanges, aggregateType));
    }
}

