/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncFileWriter
implements CompletionHandler<Integer, Map.Entry<ByteBuffer, ByteBuf>>,
Subscriber<HttpData> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncFileWriter.class);
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    private final Path path;
    private final EventExecutor eventExecutor;
    private final Set<OpenOption> options;
    private final ExecutorService blockingTaskExecutor;
    @Nullable
    private AsynchronousFileChannel fileChannel;
    @Nullable
    private Subscription subscription;
    private long position;
    private boolean writing;
    private boolean closing;

    AsyncFileWriter(StreamMessage<? extends HttpData> publisher, Path path, Set<OpenOption> options, EventExecutor eventExecutor, ExecutorService blockingTaskExecutor) {
        this.path = path;
        this.eventExecutor = eventExecutor;
        this.options = options;
        this.blockingTaskExecutor = blockingTaskExecutor;
        publisher.subscribe((Subscriber<? extends HttpData>)this, eventExecutor, SubscriptionOption.WITH_POOLED_OBJECTS);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        this.subscription = subscription;
        try {
            this.fileChannel = AsynchronousFileChannel.open(this.path, this.options, this.blockingTaskExecutor, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.maybeCloseFileChannel(e, false);
            return;
        }
        subscription.request(1L);
    }

    @Override
    public void onNext(HttpData httpData) {
        if (httpData.isEmpty()) {
            httpData.close();
            assert (this.subscription != null);
            this.subscription.request(1L);
        } else {
            ByteBuf byteBuf = httpData.byteBuf();
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            this.writing = true;
            try {
                assert (this.fileChannel != null);
                this.fileChannel.write(byteBuffer, this.position, Maps.immutableEntry(byteBuffer, byteBuf), this);
            }
            catch (Throwable ex) {
                this.maybeCloseFileChannel(ex, false);
            }
        }
    }

    @Override
    public void onError(Throwable t) {
        this.maybeCloseFileChannel(t, true);
    }

    @Override
    public void onComplete() {
        if (!this.writing) {
            this.maybeCloseFileChannel(null, false);
        } else {
            this.closing = true;
        }
    }

    CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void completed(Integer result, Map.Entry<ByteBuffer, ByteBuf> attachment) {
        assert (this.subscription != null);
        this.eventExecutor.execute(() -> {
            assert (this.subscription != null);
            ByteBuf byteBuf = (ByteBuf)attachment.getValue();
            if (result > -1) {
                this.position += (long)result.intValue();
                ByteBuffer byteBuffer = (ByteBuffer)attachment.getKey();
                if (byteBuffer.hasRemaining()) {
                    try {
                        assert (this.fileChannel != null);
                        this.fileChannel.write(byteBuffer, this.position, attachment, this);
                    }
                    catch (Throwable ex) {
                        byteBuf.release();
                        this.maybeCloseFileChannel(ex, false);
                    }
                } else {
                    byteBuf.release();
                    this.writing = false;
                    if (this.closing) {
                        this.maybeCloseFileChannel(null, false);
                    } else {
                        this.subscription.request(1L);
                    }
                }
            } else {
                byteBuf.release();
                this.subscription.cancel();
                IOException cause = new IOException("Unexpected exception while writing data to '" + this.path + "'. result: " + result);
                this.maybeCloseFileChannel(cause, false);
            }
        });
    }

    @Override
    public void failed(Throwable cause, Map.Entry<ByteBuffer, ByteBuf> attachment) {
        assert (this.subscription != null);
        this.subscription.cancel();
        attachment.getValue().release();
        this.maybeCloseFileChannel(cause, false);
    }

    private void maybeCloseFileChannel(@Nullable Throwable cause, boolean onError) {
        if (this.completionFuture.isDone()) {
            return;
        }
        if (cause == null) {
            this.completionFuture.complete(null);
        } else {
            if (!onError) {
                assert (this.subscription != null);
                this.subscription.cancel();
            }
            this.completionFuture.completeExceptionally(cause);
        }
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close '" + this.path + '\'', e);
            }
        }
    }
}

