/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

abstract class AbstractThreadFactory
implements ThreadFactory {
    private final ThreadFactoryImpl delegate;
    private final Function<? super Runnable, ? extends Runnable> taskFunction;

    AbstractThreadFactory(String threadNamePrefix, boolean daemon, int priority, @Nullable ThreadGroup threadGroup, Function<? super Runnable, ? extends Runnable> taskFunction) {
        this.delegate = new ThreadFactoryImpl(Objects.requireNonNull(threadNamePrefix, "threadNamePrefix"), daemon, priority, threadGroup);
        this.taskFunction = Objects.requireNonNull(taskFunction, "taskFunction");
    }

    @Override
    public final Thread newThread(Runnable r) {
        Runnable newRunnable = this.taskFunction.apply(r);
        Preconditions.checkState(newRunnable != null, "taskFunction.apply() returned null.");
        return this.delegate.newThread(newRunnable);
    }

    abstract Thread newThread(@Nullable ThreadGroup var1, Runnable var2, String var3);

    private final class ThreadFactoryImpl
    extends DefaultThreadFactory {
        ThreadFactoryImpl(String threadNamePrefix, boolean daemon, @Nullable int priority, ThreadGroup threadGroup) {
            super(threadNamePrefix, daemon, priority, threadGroup);
        }

        @Override
        protected Thread newThread(Runnable r, String name) {
            return AbstractThreadFactory.this.newThread(this.threadGroup, r, name);
        }
    }
}

