/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.DefaultRequestTarget;
import com.linecorp.armeria.internal.common.metric.CaffeineMetricSupport;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;

public final class RequestTargetCache {
    private static final MeterIdPrefix METER_ID_PREFIX = new MeterIdPrefix("armeria.path.cache");
    @Nullable
    private static final Cache<String, RequestTarget> SERVER_CACHE = Flags.parsedPathCacheSpec() != null ? RequestTargetCache.buildCache(Flags.parsedPathCacheSpec()) : null;
    @Nullable
    private static final Cache<String, RequestTarget> CLIENT_CACHE = Flags.parsedPathCacheSpec() != null ? RequestTargetCache.buildCache(Flags.parsedPathCacheSpec()) : null;

    private static Cache<String, RequestTarget> buildCache(String spec) {
        return Caffeine.from(spec).build();
    }

    public static void registerServerMetrics(MeterRegistry registry) {
        if (SERVER_CACHE != null) {
            CaffeineMetricSupport.setup(registry, METER_ID_PREFIX.withTags("type", "server"), SERVER_CACHE);
        }
    }

    public static void registerClientMetrics(MeterRegistry registry) {
        if (CLIENT_CACHE != null) {
            CaffeineMetricSupport.setup(registry, METER_ID_PREFIX.withTags("type", "client"), CLIENT_CACHE);
        }
    }

    @Nullable
    public static RequestTarget getForServer(String reqTarget) {
        return RequestTargetCache.get(reqTarget, SERVER_CACHE);
    }

    @Nullable
    public static RequestTarget getForClient(String reqTarget) {
        return RequestTargetCache.get(reqTarget, CLIENT_CACHE);
    }

    @Nullable
    private static RequestTarget get(String reqTarget, @Nullable Cache<String, RequestTarget> cache) {
        if (cache != null) {
            return cache.getIfPresent(reqTarget);
        }
        return null;
    }

    public static void putForServer(String reqTarget, RequestTarget normalized) {
        RequestTargetCache.put(reqTarget, normalized, SERVER_CACHE);
    }

    public static void putForClient(String reqTarget, RequestTarget normalized) {
        RequestTargetCache.put(reqTarget, normalized, CLIENT_CACHE);
    }

    private static void put(String reqTarget, RequestTarget normalized, @Nullable Cache<String, RequestTarget> cache) {
        DefaultRequestTarget value;
        assert (reqTarget != null);
        assert (normalized != null);
        if (cache != null && normalized instanceof DefaultRequestTarget && !(value = (DefaultRequestTarget)normalized).isCached()) {
            value.setCached();
            cache.put(reqTarget, normalized);
        }
    }

    public static void clearCachedPaths() {
        assert (CLIENT_CACHE != null) : "CLIENT_CACHE";
        assert (SERVER_CACHE != null) : "SERVER_CACHE";
        CLIENT_CACHE.asMap().clear();
        SERVER_CACHE.asMap().clear();
    }

    public static Set<String> cachedServerPaths() {
        assert (SERVER_CACHE != null) : "SERVER_CACHE";
        return SERVER_CACHE.asMap().keySet();
    }

    public static Set<String> cachedClientPaths() {
        assert (CLIENT_CACHE != null) : "CLIENT_CACHE";
        return CLIENT_CACHE.asMap().keySet();
    }

    private RequestTargetCache() {
    }
}

