/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

final class AnnotatedObjectFactory {
    static <T> T getInstance(Annotation annotation, Class<T> expectedType, DependencyInjector dependencyInjector) {
        Class type = (Class)AnnotatedObjectFactory.invokeValueMethod(annotation);
        Object instance = dependencyInjector.getInstance(type);
        if (instance != null) {
            if (!expectedType.isInstance(instance)) {
                throw new IllegalArgumentException("A class specified in @" + annotation.annotationType().getSimpleName() + " annotation cannot be cast to " + expectedType);
            }
            return instance;
        }
        throw new IllegalArgumentException("cannot inject the dependency for " + type.getName() + ". Use " + DependencyInjector.class.getName() + " or add a default constructor to create the instance.");
    }

    static Object invokeValueMethod(Annotation a) {
        try {
            Method method = Iterables.getFirst(ReflectionUtils.getMethods(a.annotationType(), ReflectionUtils.withName("value")), null);
            assert (method != null) : "No 'value' method is found from " + a;
            return method.invoke((Object)a, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("An annotation @" + a.annotationType().getSimpleName() + " must have a 'value' method", e);
        }
    }

    private AnnotatedObjectFactory() {
    }
}

