/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1String;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1UniversalType;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERVisibleString;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1VisibleString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1VisibleString.class, 26){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1VisibleString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1VisibleString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 26, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1VisibleString)) {
            return false;
        }
        ASN1VisibleString aSN1VisibleString = (ASN1VisibleString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1VisibleString.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1VisibleString createPrimitive(byte[] byArray) {
        return new DERVisibleString(byArray, false);
    }
}

