/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.objects;

import com.linecorp.armeria.internal.shaded.fastutil.Size64;
import com.linecorp.armeria.internal.shaded.fastutil.objects.AbstractReferenceList;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectArrays;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectListIterator;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectSpliterator;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectSpliterators;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ReferenceCollection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public interface ReferenceList<K>
extends ReferenceCollection<K>,
List<K> {
    @Override
    public ObjectListIterator<K> iterator();

    @Override
    default public ObjectSpliterator<K> spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractReferenceList.IndexBasedSpliterator(this, 0);
        }
        return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16464);
    }

    @Override
    public ObjectListIterator<K> listIterator();

    @Override
    public ObjectListIterator<K> listIterator(int var1);

    @Override
    public ReferenceList<K> subList(int var1, int var2);

    public void getElements(int var1, Object[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(K[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index, K[] a) {
        this.setElements(index, a, 0, a.length);
    }

    default public void setElements(int index, K[] a, int offset, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        ObjectArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        ListIterator iter2 = this.listIterator(index);
        int i = 0;
        while (i < length) {
            iter2.next();
            iter2.set(a[offset + i++]);
        }
    }

    @Override
    default public boolean addAll(int index, ReferenceList<? extends K> l) {
        return this.addAll(index, l);
    }

    @Override
    default public boolean addAll(ReferenceList<? extends K> l) {
        return this.addAll(this.size(), l);
    }

    @Override
    default public void sort(Comparator<? super K> comparator) {
        Object[] elements = this.toArray();
        if (comparator == null) {
            ObjectArrays.stableSort(elements);
        } else {
            ObjectArrays.stableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

