/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import io.netty.util.AsciiString;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RoutingPredicate<T> {
    private static final Logger logger = LoggerFactory.getLogger(RoutingPredicate.class);
    private static final Pattern CONTAIN_PATTERN = Pattern.compile("^\\s*([!]?)([^\\s=><!]+)\\s*$");
    private static final Pattern COMPARE_PATTERN = Pattern.compile("^\\s*([^\\s!><=]+)\\s*([><!]?=|>|<)(.*)$");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern OR_PATTERN = Pattern.compile("\\s*\\|\\|\\s*");
    private final CharSequence name;
    private final Predicate<T> delegate;
    private final boolean customPredicate;

    static List<RoutingPredicate<HttpHeaders>> copyOfHeaderPredicates(Iterable<String> predicates) {
        return Streams.stream(predicates).map(RoutingPredicate::ofHeaders).collect(ImmutableList.toImmutableList());
    }

    static List<RoutingPredicate<QueryParams>> copyOfParamPredicates(Iterable<String> predicates) {
        return Streams.stream(predicates).map(RoutingPredicate::ofParams).collect(ImmutableList.toImmutableList());
    }

    static RoutingPredicate<HttpHeaders> ofHeaders(CharSequence headerName, Predicate<? super String> valuePredicate) {
        AsciiString name = HttpHeaderNames.of(headerName);
        return new RoutingPredicate<HttpHeaders>(headerName, headers -> headers.getAll(name).stream().anyMatch(valuePredicate), true);
    }

    static RoutingPredicate<HttpHeaders> ofHeaders(String headersPredicate) {
        Objects.requireNonNull(headersPredicate, "headersPredicate");
        return RoutingPredicate.of(headersPredicate, HttpHeaderNames::of, name -> headers -> headers.contains((CharSequence)name), (name, value) -> headers -> headers.getAll((CharSequence)name).stream().anyMatch(value::equals));
    }

    static RoutingPredicate<QueryParams> ofParams(String paramName, Predicate<? super String> valuePredicate) {
        return new RoutingPredicate<QueryParams>(paramName, params -> params.getAll(paramName).stream().anyMatch(valuePredicate), true);
    }

    static RoutingPredicate<QueryParams> ofParams(String paramsPredicate) {
        Objects.requireNonNull(paramsPredicate, "paramsPredicate");
        return RoutingPredicate.of(paramsPredicate, Function.identity(), name -> params -> params.contains((String)name), (name, value) -> params -> params.getAll((String)name).stream().anyMatch(value::equals));
    }

    static <T, U> RoutingPredicate<T> of(String predicateExpr, Function<String, U> nameConverter, Function<U, Predicate<T>> containsPredicate, BiFunction<U, String, Predicate<T>> equalsPredicate) {
        RoutingPredicate<T> routingPredicate = RoutingPredicate.parseRoutingPredicate(predicateExpr, nameConverter, containsPredicate, equalsPredicate);
        Preconditions.checkArgument(routingPredicate != null, "Invalid predicate: %s (expected: name, !name, name=value, name!=value or any of them concatenated by '||')", (Object)predicateExpr);
        return new RoutingPredicate<T>(routingPredicate.name, routingPredicate.delegate, false);
    }

    @Nullable
    private static <T, U> RoutingPredicate<T> parseRoutingPredicate(String predicateExpr, Function<String, U> nameConverter, Function<U, Predicate<T>> containsPredicate, BiFunction<U, String, Predicate<T>> equalsPredicate) {
        RoutingPredicate<T> result = null;
        for (String expr : OR_PATTERN.split(predicateExpr, -1)) {
            if (expr.isEmpty()) {
                return null;
            }
            RoutingPredicate<T> predicate = RoutingPredicate.parseSingleRoutingPredicate(expr, nameConverter, containsPredicate, equalsPredicate);
            if (predicate == null) {
                return null;
            }
            result = result == null ? predicate : RoutingPredicate.or(result, predicate);
        }
        return result;
    }

    @Nullable
    private static <T, U> RoutingPredicate<T> parseSingleRoutingPredicate(String predicateExpr, Function<String, U> nameConverter, Function<U, Predicate<T>> containsPredicate, BiFunction<U, String, Predicate<T>> equalsPredicate) {
        if (predicateExpr.contains("|")) {
            return null;
        }
        RoutingPredicate<T> containRoutingPredicate = RoutingPredicate.parseContainRoutingPredicate(predicateExpr, nameConverter, containsPredicate);
        RoutingPredicate<T> routingPredicate = containRoutingPredicate != null ? containRoutingPredicate : RoutingPredicate.parseCompareRoutingPredicate(predicateExpr, nameConverter, equalsPredicate);
        return routingPredicate;
    }

    @Nullable
    private static <T, U> RoutingPredicate<T> parseContainRoutingPredicate(String predicateExpr, Function<String, U> nameConverter, Function<U, Predicate<T>> containsPredicate) {
        Matcher containMatcher = CONTAIN_PATTERN.matcher(predicateExpr);
        if (containMatcher.matches()) {
            U name = nameConverter.apply(containMatcher.group(2));
            Predicate<T> predicate = containsPredicate.apply(name);
            if ("!".equals(containMatcher.group(1))) {
                return RoutingPredicate.negated(containMatcher.group(2), predicate);
            }
            return RoutingPredicate.from(predicateExpr, predicate);
        }
        return null;
    }

    @Nullable
    private static <T, U> RoutingPredicate<T> parseCompareRoutingPredicate(String predicateExpr, Function<String, U> nameConverter, BiFunction<U, String, Predicate<T>> equalsPredicate) {
        Matcher compareMatcher = COMPARE_PATTERN.matcher(predicateExpr);
        if (compareMatcher.matches()) {
            assert (compareMatcher.groupCount() == 3);
            String name = compareMatcher.group(1);
            String comparator = compareMatcher.group(2);
            String value = compareMatcher.group(3);
            Predicate<T> predicate = equalsPredicate.apply((String)nameConverter.apply(name), value);
            String noWsValue = WHITESPACE_PATTERN.matcher(value).replaceAll("_");
            switch (comparator) {
                case "=": {
                    return RoutingPredicate.eq(name, noWsValue, predicate);
                }
                case "!=": {
                    return RoutingPredicate.notEq(name, noWsValue, predicate);
                }
            }
        }
        return null;
    }

    RoutingPredicate(CharSequence name, Predicate<T> delegate, boolean customPredicate) {
        this.name = Objects.requireNonNull(name, "name");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.customPredicate = customPredicate;
    }

    CharSequence name() {
        return this.name;
    }

    boolean isCustomPredicate() {
        return this.customPredicate;
    }

    public boolean test(T t) {
        try {
            return this.delegate.test(t);
        }
        catch (Throwable cause) {
            if (Flags.verboseExceptionSampler().isSampled(cause.getClass())) {
                logger.warn("Failed to evaluate the value of header or param '{}'. You MUST catch and handle this exception properly: input={}", this.name, t, cause);
            }
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoutingPredicate)) {
            return false;
        }
        RoutingPredicate that = (RoutingPredicate)o;
        return this.name.equals(that.name) && this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.delegate.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("delegate", this.delegate).toString();
    }

    private static <T> RoutingPredicate<T> eq(String name, String value, Predicate<T> predicate) {
        return new RoutingPredicate<T>(name + "_eq_" + value, predicate, false);
    }

    private static <T> RoutingPredicate<T> notEq(String name, String value, Predicate<T> predicate) {
        return new RoutingPredicate<T>(name + "_ne_" + value, predicate.negate(), false);
    }

    private static <T> RoutingPredicate<T> negated(String name, Predicate<T> predicate) {
        return new RoutingPredicate<T>("not_" + name, predicate.negate(), false);
    }

    private static <T> RoutingPredicate<T> from(String name, Predicate<T> predicate) {
        return new RoutingPredicate<T>(name, predicate, false);
    }

    private static <T> RoutingPredicate<T> or(RoutingPredicate<T> current, RoutingPredicate<T> other) {
        String currentName = String.valueOf(current.name);
        if (currentName.isEmpty()) {
            return new RoutingPredicate<T>(other.name + "_or_", current.delegate.or(other.delegate), false);
        }
        if (currentName.endsWith("_or_")) {
            return new RoutingPredicate<T>(currentName + other.name, current.delegate.or(other.delegate), false);
        }
        return new RoutingPredicate<T>(currentName + "_or_" + other.name, current.delegate.or(other.delegate), false);
    }
}

