/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.file.HttpFile;
import java.lang.reflect.Type;
import org.reactivestreams.Subscriber;

public final class HttpFileResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType produceType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (HttpFile.class.isAssignableFrom(clazz)) {
            return true;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, final ResponseHeaders headers, @Nullable Object result, final HttpHeaders trailers) throws Exception {
        if (result instanceof HttpFile) {
            HttpResponse originalRes = ((HttpFile)result).asService().serve(ctx, ctx.request());
            if (!HttpFileResponseConverterFunction.shouldOverride(headers, trailers)) {
                return originalRes;
            }
            return new FilteredHttpResponse(originalRes){
                private boolean trailerSent;

                @Override
                protected HttpObject filter(HttpObject obj) {
                    if (obj instanceof ResponseHeaders) {
                        ResponseHeaders originalHeaders = (ResponseHeaders)obj;
                        if (!originalHeaders.status().isInformational()) {
                            return headers.toBuilder().set((Iterable)originalHeaders).build();
                        }
                    } else if (obj instanceof HttpHeaders) {
                        this.trailerSent = true;
                        if (!trailers.isEmpty()) {
                            return trailers.toBuilder().set((HttpHeaders)obj).build();
                        }
                    }
                    return obj;
                }

                @Override
                protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
                    if (!trailers.isEmpty() && !this.trailerSent) {
                        subscriber.onNext(trailers);
                    }
                }
            };
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static boolean shouldOverride(ResponseHeaders headers, HttpHeaders trailers) {
        if (!trailers.isEmpty()) {
            return true;
        }
        if (headers.isEmpty()) {
            return false;
        }
        return headers.size() != 1 || !headers.contains(HttpHeaderNames.STATUS);
    }
}

