/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rules;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.envoy.ServiceMetaInfoFactory;
import org.apache.skywalking.oap.server.receiver.envoy.ServiceMetaInfoFactoryImpl;
import org.apache.skywalking.oap.server.receiver.envoy.metrics.adapters.ClusterManagerMetricsAdapter;

public class EnvoyMetricReceiverConfig
extends ModuleConfig {
    private boolean acceptMetricsService = false;
    private String alsHTTPAnalysis;
    private String alsTCPAnalysis;
    private String k8sServiceNameRule;
    private String istioServiceNameRule;
    private String istioServiceEntryIgnoredNamespaces;
    private String gRPCHost;
    private int gRPCPort;
    private int maxConcurrentCallsPerConnection;
    private int maxMessageSize;
    private int gRPCThreadPoolSize;
    private boolean gRPCSslEnabled = false;
    private String gRPCSslKeyPath;
    private String gRPCSslCertChainPath;
    private String gRPCSslTrustedCAsPath;
    private final ServiceMetaInfoFactory serviceMetaInfoFactory = new ServiceMetaInfoFactoryImpl();
    private final ClusterManagerMetricsAdapter clusterManagerMetricsAdapter = new ClusterManagerMetricsAdapter(this);

    public List<String> getAlsHTTPAnalysis() {
        if (Strings.isNullOrEmpty((String)this.alsHTTPAnalysis)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.alsHTTPAnalysis.trim().split(",")).map(String::trim).collect(Collectors.toList());
    }

    public List<String> getAlsTCPAnalysis() {
        if (Strings.isNullOrEmpty((String)this.alsTCPAnalysis)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.alsTCPAnalysis.trim().split(",")).map(String::trim).collect(Collectors.toList());
    }

    public List<Rule> rules() throws ModuleStartException {
        try {
            return Rules.loadRules((String)"envoy-metrics-rules", Arrays.asList("envoy", "envoy-svc-relation"));
        }
        catch (IOException e) {
            throw new ModuleStartException("Failed to load envoy-metrics-rules", (Throwable)e);
        }
    }

    public ServiceMetaInfoFactory serviceMetaInfoFactory() {
        return this.serviceMetaInfoFactory;
    }

    public Set<String> getIstioServiceEntryIgnoredNamespaces() {
        String s = Strings.nullToEmpty((String)this.istioServiceEntryIgnoredNamespaces);
        return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToStream((CharSequence)s).collect(Collectors.toSet());
    }

    @Generated
    public boolean isAcceptMetricsService() {
        return this.acceptMetricsService;
    }

    @Generated
    public String getK8sServiceNameRule() {
        return this.k8sServiceNameRule;
    }

    @Generated
    public String getIstioServiceNameRule() {
        return this.istioServiceNameRule;
    }

    @Generated
    public String getGRPCHost() {
        return this.gRPCHost;
    }

    @Generated
    public int getGRPCPort() {
        return this.gRPCPort;
    }

    @Generated
    public int getMaxConcurrentCallsPerConnection() {
        return this.maxConcurrentCallsPerConnection;
    }

    @Generated
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Generated
    public int getGRPCThreadPoolSize() {
        return this.gRPCThreadPoolSize;
    }

    @Generated
    public boolean isGRPCSslEnabled() {
        return this.gRPCSslEnabled;
    }

    @Generated
    public String getGRPCSslKeyPath() {
        return this.gRPCSslKeyPath;
    }

    @Generated
    public String getGRPCSslCertChainPath() {
        return this.gRPCSslCertChainPath;
    }

    @Generated
    public String getGRPCSslTrustedCAsPath() {
        return this.gRPCSslTrustedCAsPath;
    }

    @Generated
    public ClusterManagerMetricsAdapter getClusterManagerMetricsAdapter() {
        return this.clusterManagerMetricsAdapter;
    }
}

