/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc.classloader;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClassLoaderManagerFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PackageAdmin pckAdmin;
    private final BundleContext context;
    private final Set<Long> usedBundles = Collections.synchronizedSet(new HashSet());
    private final Set<String> unresolvedPackages = Collections.synchronizedSet(new HashSet());

    public DynamicClassLoaderManagerFactory(BundleContext ctx, PackageAdmin pckAdmin) {
        this.context = ctx;
        this.pckAdmin = pckAdmin;
    }

    public boolean isBundleUsed(long bundleId) {
        return this.usedBundles.contains(bundleId);
    }

    public void addUsedBundle(Bundle bundle) {
        long id = bundle.getBundleId();
        this.usedBundles.add(id);
    }

    public void addUnresolvedPackage(String pckName) {
        this.unresolvedPackages.add(pckName);
    }

    public boolean hasUnresolvedPackages(Bundle bundle) {
        ExportedPackage[] pcks;
        if (!this.unresolvedPackages.isEmpty() && (pcks = this.pckAdmin.getExportedPackages(bundle)) != null) {
            for (ExportedPackage pck : pcks) {
                if (!this.unresolvedPackages.contains(pck.getName())) continue;
                this.logger.debug("Bundle '{}' provides package '{}' which has been previously unsuccessfully requested!", (Object)bundle, (Object)pck.getName());
                return true;
            }
        }
        return false;
    }
}

