/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.Nonce;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthCookieValue {
    public static final String COOKIE_NAME_REQUEST_KEY = "sling.oauth-request-key";
    @NotNull
    private final String perRequestKey;
    @NotNull
    private final String connectionName;
    @Nullable
    private final String redirect;
    @Nullable
    private Nonce nonce;
    @Nullable
    private CodeVerifier codeVerifier;
    private static final Logger logger = LoggerFactory.getLogger(OAuthCookieValue.class);
    public static final int STATE_INDEX = 0;
    public static final int CONNECTION_NAME_INDEX = 1;
    public static final int REDIRECT_INDEX = 2;
    public static final int NONCE_INDEX = 3;
    public static final int CODE_VERIFIER_INDEX = 4;

    public OAuthCookieValue(@NotNull String perRequestKey, @NotNull String connectionName, @Nullable String redirect) {
        this.perRequestKey = perRequestKey;
        this.connectionName = connectionName;
        this.redirect = redirect;
    }

    public OAuthCookieValue(@NotNull String perRequestKey, @NotNull String connectionName, @Nullable String redirect, @NotNull Nonce nonce, @Nullable CodeVerifier codeVerifier) {
        this.perRequestKey = perRequestKey;
        this.connectionName = connectionName;
        this.redirect = redirect;
        this.nonce = nonce;
        this.codeVerifier = codeVerifier;
    }

    public OAuthCookieValue(@NotNull String encyptedValue, @NotNull CryptoService cryptoService) {
        String decryptedValue = cryptoService.decrypt(encyptedValue);
        String[] parts = decryptedValue.split("\\|");
        if (parts.length < 2) {
            logger.error("Invalid OAuthCookieValue format: {}", (Object)decryptedValue);
            throw new IllegalArgumentException("Invalid OAuthCookieValue format");
        }
        this.perRequestKey = parts[0];
        this.connectionName = parts[1];
        this.redirect = parts.length > 2 ? (parts[2].isEmpty() ? null : parts[2]) : null;
        if (parts.length > 3) {
            Nonce nonce = this.nonce = parts[3].isEmpty() ? null : new Nonce(parts[3]);
        }
        if (parts.length > 4) {
            this.codeVerifier = parts[4].isEmpty() ? null : new CodeVerifier(parts[4]);
        }
    }

    @NotNull
    public String perRequestKey() {
        return this.perRequestKey;
    }

    @NotNull
    public State getState() {
        return new State(this.perRequestKey);
    }

    @NotNull
    public String connectionName() {
        return this.connectionName;
    }

    @Nullable
    public String redirect() {
        return this.redirect;
    }

    @Nullable
    public Nonce nonce() {
        return this.nonce;
    }

    @Nullable
    public CodeVerifier codeVerifier() {
        return this.codeVerifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthCookieValue)) {
            return false;
        }
        OAuthCookieValue that = (OAuthCookieValue)o;
        if (!this.perRequestKey.equals(that.perRequestKey)) {
            return false;
        }
        if (!this.connectionName.equals(that.connectionName)) {
            return false;
        }
        if (this.redirect != null ? !this.redirect.equals(that.redirect) : that.redirect != null) {
            return false;
        }
        if (this.nonce != null ? !this.nonce.equals((Object)that.nonce) : that.nonce != null) {
            return false;
        }
        return !(this.codeVerifier != null ? !this.codeVerifier.equals((Object)that.codeVerifier) : that.codeVerifier != null);
    }

    public int hashCode() {
        int result = this.perRequestKey.hashCode();
        result = 31 * result + this.connectionName.hashCode();
        result = 31 * result + (this.redirect != null ? this.redirect.hashCode() : 0);
        result = 31 * result + (this.nonce != null ? this.nonce.hashCode() : 0);
        result = 31 * result + (this.codeVerifier != null ? this.codeVerifier.hashCode() : 0);
        return result;
    }

    @NotNull
    public String getValue() {
        return this.perRequestKey + "|" + this.connectionName + "|" + (this.redirect == null ? "" : this.redirect) + "|" + (this.nonce == null ? "" : this.nonce.getValue()) + "|" + (this.codeVerifier == null ? "" : this.codeVerifier.getValue());
    }
}

