/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.selector;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.auth.selector.SelectorAuthenticationHandler")
@Properties(value={@Property(name="service.description", value={"Apache Sling Selector Form Handler"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="path", value={"/"}), @Property(name="service.ranking", intValue={5000})})
@Service
public class SelectorAuthenticationHandler
extends AbstractAuthenticationHandler {
    static final String PAR_SELECTED_AUTH_TYPE = "selectedAuthType";
    @Property(value={"/system/sling/selector/login"})
    private static final String PAR_LOGIN_FORM = "form.login.form";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String loginForm;

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) {
        if (!AuthUtil.checkReferer((HttpServletRequest)request, (String)this.loginForm)) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", SelectorAuthenticationHandler.getLoginResource((HttpServletRequest)request, null));
        if (request.getAttribute("j_reason") != null) {
            Object jReason = request.getAttribute("j_reason");
            String reason = jReason instanceof Enum ? ((Enum)jReason).name() : jReason.toString();
            params.put("j_reason", reason);
        }
        if (request.getParameter(PAR_SELECTED_AUTH_TYPE) != null) {
            params.put(PAR_SELECTED_AUTH_TYPE, request.getParameter(PAR_SELECTED_AUTH_TYPE));
        }
        try {
            SelectorAuthenticationHandler.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)this.loginForm, params);
        }
        catch (IOException e) {
            this.log.error("Failed to redirect to the login form " + this.loginForm, (Throwable)e);
        }
        return true;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
    }

    @Activate
    @Modified
    private void configure(Map<String, ?> properties) {
        this.loginForm = OsgiUtil.toString(properties.get(PAR_LOGIN_FORM), "/system/sling/selector/login");
        this.log.info("Login Form URL {}", (Object)this.loginForm);
    }
}

