/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.impl;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.reference.SearchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SearchService.class, SlingRequestListener.class})
@Designate(ocd=Config.class)
public class SearchServiceImpl
implements SearchService,
SlingRequestListener {
    private static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);
    private final ResourceResolverFactory factory;
    private final Config config;
    private static final String RESOURCE_RESOLVER_ATTR = SearchServiceImpl.class.getName() + ":ResourceResolver";

    @Activate
    public SearchServiceImpl(@Reference ResourceResolverFactory factory, Config config) {
        this.factory = factory;
        this.config = config;
    }

    @Override
    public ResourceResolver getResourceResolver(SlingHttpServletRequest request) {
        if (this.config != null && StringUtils.isNotBlank((CharSequence)this.config.searchServiceUsername())) {
            try {
                log.debug("Retrieving Service User {}", (Object)this.config.searchServiceUsername());
                ResourceResolver resolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", this.config.searchServiceUsername()));
                request.setAttribute(RESOURCE_RESOLVER_ATTR, (Object)resolver);
                return resolver;
            }
            catch (LoginException e) {
                log.warn("Failed to retrieve Service User {}, falling back to request user", (Object)this.config.searchServiceUsername(), (Object)e);
                return request.getResourceResolver();
            }
        }
        log.debug("Using request user");
        return request.getResourceResolver();
    }

    public void onEvent(SlingRequestEvent sre) {
        if (sre.getType() == SlingRequestEvent.EventType.EVENT_DESTROY && sre.getServletRequest().getAttribute(RESOURCE_RESOLVER_ATTR) != null && sre.getServletRequest().getAttribute(RESOURCE_RESOLVER_ATTR) instanceof ResourceResolver) {
            ResourceResolver resolver = (ResourceResolver)sre.getServletRequest().getAttribute(RESOURCE_RESOLVER_ATTR);
            resolver.close();
        }
    }

    @ObjectClassDefinition(name="%cms.reference.search.name", description="%cms.reference.search.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%searchServiceUsername.name", description="%searchServiceUsername.description")
        public String searchServiceUsername();
    }
}

