/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public class AttrValue
implements CharSequence {
    Predicate<String> nonQuotable = Pattern.compile("^[a-zA-Z][-_a-zA-Z0-9\\u00A0-\\u10FFFF]*$").asPredicate();
    private String value;

    public AttrValue() {
    }

    public AttrValue(String value) {
        this.value = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String quoteIfNeeded() {
        if (this.shouldBeQuoted()) {
            return this.getQuoted('\"');
        }
        return this.value;
    }

    public String getQuoted(char paren) {
        if (this.isEmpty()) {
            return null;
        }
        return paren + this.value + paren;
    }

    public boolean shouldBeQuoted() {
        if (this.isEmpty()) {
            return false;
        }
        return this.nonQuotable.negate().test(this.value);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public int length() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }
}

