/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.jcr;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;

public class MockNodeIterator
implements NodeIterator {
    private Node[] nodes;
    private int idx;
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    public MockNodeIterator() {
        this(EMPTY_NODE_ARRAY);
    }

    public MockNodeIterator(Node[] nodes) {
        this.nodes = nodes != null ? nodes : new Node[]{};
        this.idx = 0;
    }

    public Node nextNode() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nodes[this.idx++];
    }

    public long getPosition() {
        return this.idx - 1;
    }

    public long getSize() {
        return this.nodes.length;
    }

    public void skip(long skipNum) {
        this.idx = (int)((long)this.idx + skipNum);
    }

    public boolean hasNext() {
        return this.idx < this.nodes.length;
    }

    public Object next() {
        return this.nextNode();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

